package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.support.ServletUtils;
import com.geoway.design.biz.service.dev.ILoginService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.rpc.SsoUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @description: 登录实现类工厂
 * @author: wujing
 * @date: 2025-04-24 18:04
 */
@Service
public class LoginSysFactory {

    @Autowired
    @Qualifier("userService")
    private LocalLoginServiceImpl defaultService;

    @Resource
    private Map<String, ILoginService> userServiceMap;

    @Autowired
    private IOauth2Service oauth2Service;

    /**
     * 获取登录体系
     * @param type
     * @return
     */
    public ILoginService getService(String type){
        for (Map.Entry<String, ILoginService> entry : userServiceMap.entrySet()) {
            String userSys = entry.getValue().getUserSys();
            if(type.equals(userSys)){
                return entry.getValue();
            }
        }
        return defaultService;
    }

    public ILoginService getService(){
        // 根据当前用户的token用户体系
        String type = getType();
        return getService(type);
    }

    /**
     * 根据token获取用户体系
     * @return
     */
    private String getType(){
        String type = null;
        try {
            HttpServletRequest request = ServletUtils.getRequest();
            SsoUser ssoUser = oauth2Service.queryCurrentSsoUser(request);
            type = ssoUser.getSource();
        }catch (Exception e){}
        return type;
    }

}
