package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.BimOrg;
import com.geoway.design.biz.mapper.BimOrgMapper;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.service.hunan.BimOrgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author AA
 */
@Service
@Transactional
public class BimOrgServiceImpl extends ServiceImpl<BimOrgMapper, BimOrg>  implements BimOrgService {

    @Autowired
    SysOrganizationMapper sysOrganizationMapper;

    @Override
    public void saveBimOrg(BimOrg bimOrg) throws Exception {

        //获取级别信息
        if (StrUtil.isBlank(bimOrg.getPid())) {
            bimOrg.setPid("0");
        }
        BimOrg oldOrg = this.getById(bimOrg.getId());
        boolean isAdd= oldOrg == null ? true: false;
        if (isAdd) {
            Integer maxOrder = sysOrganizationMapper.queryMaxOrderByPid(bimOrg.getPid());
            int order = maxOrder == null ? 1 : maxOrder + 1;
            bimOrg.setOrder(order);
        }

        if(isAdd) {
            this.save(bimOrg);
        }else{
            this.updateById(bimOrg);
        }


    }
}


