package com.geoway.design.biz.service.login;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;

/**
 * @author ALMJ
 * @desc 应用服务接口
 */
public interface ICaptchaService {
    /**
     * 生成验证码
     *
     * @param width
     * @param height
     * @param req
     * @param resp
     * @return
     */
    BufferedImage createImageCaptcha(String uuid,String width, String height, HttpServletRequest req, HttpServletResponse resp);

    void storeCaptcha(String sessionId, String captchaText);

    String queryCaptcha(String sessionId);
    /**
     * 移除
     * @param sessionId
     * @return
     */
    void removeCaptcha(String sessionId);
    /**
     * 登录验证码验证服务
     *
     * @param code 验证码
     * @return
     */
    boolean validateCaptcha(String code, String storeCode);
}
