package com.geoway.design.biz.service.login;

import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;

import javax.servlet.http.HttpServletRequest;
/**
 * @author ALMJ
 * @desc
 * @date 2021/8/9 18:06
 */
public interface ISysLoginService {

    ResponseDataBase checkLogin(String username, String password, String vCode, String code, HttpServletRequest request);

    ResponseDataBase checkLogin(String username, String password, HttpServletRequest request);
    /**
     * 重定向到单点登录界面
     *
     * @param redirectUri
     * @return
     */
    String redirectToSsoLogin(String redirectUri);

    /**
     * 获取单点退出接口
     *
     * @param redirectUri
     * @return
     */
    String getSsoLogoutUrl(String redirectUri, HttpServletRequest request);

    /**
     * 通过代码获取访问令牌
     *
     * @param code
     * @return
     */
    Result<RpcAccessToken> getAccessTokenByCode(String code, HttpServletRequest request);

    ResponseDataBase restLogout(HttpServletRequest request,String access_token);

    boolean checkIsResetPassword(String accessToken);

    ResponseDataBase validUserOnline(String username, String password);

}
