package com.geoway.design.biz.service.login.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.support.EncodeUtil;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.dto.OneLoginRequestData;
import com.geoway.design.biz.dto.OneLoginResponseData;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.login.IAppLoginService;
import com.geoway.design.biz.service.login.ISysLoginService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * @author daidd
 * @desc APP登录服务接口
 */
@Service
public class AppServiceImpl  implements IAppLoginService {

    @Value("${oneLogin.appId: }")
    private String appId;

    @Value("${oneLogin.appKey: }")
    private String appKey;

    @Value("${oneLogin.verifyURL: }")
    private String verifyURL;

    @Autowired
    SysUserMapper sysUserMapper;

    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;

    @Autowired
    ISysLoginService sysLoginService;


    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Override
    public ResponseDataBase LoginAppByOneLogin(HttpServletRequest request, String processId, String token, String authCode) throws Exception {

        ResponseDataBase response = new ResponseDataBase();
        Long currentTime = System.currentTimeMillis();
        String sign = createSign(currentTime);

        OneLoginRequestData oneLoginParam = new OneLoginRequestData();
        oneLoginParam.setProcess_id(processId);
        oneLoginParam.setSign(sign);
        oneLoginParam.setToken(token);
        oneLoginParam.setTimestamp(currentTime);
        if(StrUtil.isNotBlank(authCode)){
            oneLoginParam.setAuthCode(authCode);
        }
        OneLoginResponseData respData = vertifyAppOneLoginByHttpPost(oneLoginParam);
        if(respData.getStatus() == 200){
            String phoneNumber = respData.getResult();
            SysUser user = querySysUserByPhone(phoneNumber);
            String tel = user.getTel();
            if(StrUtil.isBlank(tel)){
                tel = user.getWorktel();
            }
            SysUserSecurity sysUserSecurity = sysUserSecurityMapper.selectById(user.getId());
            response = sysLoginService.checkLogin(user.getAccout(),sysUserSecurity.getPassword(),request);

            response.put("userName",user.getName());
            response.put("aliasName",user.getAname());
//            response.put("tel",tel);

        }else {
            throw new Exception("获取手机号码失败:" + respData.getStatus() + ":" +  respData.getError_msg());
        }

       return  response;
    }

    private OneLoginResponseData vertifyAppOneLoginByHttpPost(OneLoginRequestData oneLoginParam) throws RuntimeException {

        OneLoginResponseData respData = null;
        HttpClient httpclient = null;
        HttpPost httpPost = null;
        HttpEntity httpEntity = null;
        try{
            String body = JSONObject.toJSONString(oneLoginParam);
            httpclient = HttpClients.createDefault();
            httpPost = new HttpPost(verifyURL);
            httpPost.addHeader("Accept","*/*");
            httpPost.addHeader("content-Type","application/json;charset=utf8");

            httpPost.setEntity(new StringEntity(body, StandardCharsets.UTF_8));
            //发送请求
            HttpResponse response = httpclient.execute(httpPost);

            httpEntity = response.getEntity();
            String content = EntityUtils.toString(httpEntity,"UTF-8");
            respData = JSONObject.parseObject(content,OneLoginResponseData.class);

        }catch (Exception ex){
            logger.error("HTTP请求失败:" + ex.getMessage());
            throw new RuntimeException("网络请求错误，获取手机号码失败");
        }
        finally {
            //释放资源
            try{
                if(httpEntity != null){
                    EntityUtils.consume(httpEntity);
                }
            }catch (Exception e){
                logger.error("HTTP请求释放资源异常:" + e.getMessage());
            }
        }

        return respData;
    }

    private SysUser querySysUserByPhone(String phoneNumber) throws Exception {

        LambdaQueryWrapper<SysUser> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getTelEncrypt, AESUtils.encrypt(phoneNumber,AESUtils.KEY));
        queryWrapper.or();
        queryWrapper.eq(SysUser::getWorktel, AESUtils.encrypt(phoneNumber,AESUtils.KEY));

        List<SysUser> users = sysUserMapper.selectList(queryWrapper);
        if (users == null || users.size() == 0) {
            throw new Exception("此手机号码未注册");
        }
        SysUser user =  users.get(0);

        return  user;
    }

    private String createSign(Long currentTime){

        String message = appId + "&&" + currentTime;
        return EncodeUtil.hmacSha256(message,appKey);
    }
}
