package com.geoway.design.biz.service.login.impl;

import cn.org.bjca.client.security.SecurityEngineDeal;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.service.login.ICaLoginService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CaLoginServiceImpl implements ICaLoginService {
  @Autowired
  private ISysUserService sysUserService;
  
  @Autowired
  private SysRegionMapper sysRegionMapper;
  
  @Autowired
  private AccessTokenManager accessTokenManager;
  
  @Autowired
  private ProjectConfig projectConfig;
  
  @Autowired
  private RefreshTokenManager refreshTokenManager;
  
  @Autowired
  private TicketGrantingTicketManager ticketGrantingTicketManager;
  
  @Autowired
  private ISysUserRoleService sysUserRoleService;
  
  public ResponseDataBase checkLogin(String UserCert, String oauthName) {
    ResponseDataBase response = new ResponseDataBase();
    if (oauthName == null)
      return ResponseDataBase.error("缺少参数oauthName"); 
    try {
      Result<SsoUser> loginResult = validate(UserCert);
      if (loginResult == null)
        return ResponseDataBase.error("证书验证失败请联系管理员");
      else if (loginResult.getCode()== Oauth2Constant.ERROR_CODE)
        return ResponseDataBase.error(loginResult.getMessage());
      SsoUser user = (SsoUser)loginResult.getData();
      String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
      CodeContent codeContent = new CodeContent(tgt, false, null);
      Result<AccessTokenContent> authDto = Result.createSuccess(new AccessTokenContent(codeContent, user, this.projectConfig.getSsoAppId(), null));
      ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
      HttpServletRequest request = servletRequestAttributes.getRequest();
      String newAccessToken = this.accessTokenManager.generate((AccessTokenContent)authDto.getData());
      String refreshToken = this.refreshTokenManager.generate((AccessTokenContent)authDto.getData(), newAccessToken);
      AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
      tokenContent.setRefreshToken(refreshToken);
      this.accessTokenManager.create(newAccessToken, tokenContent);
      RpcAccessToken rpcAccessToken = new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, ((AccessTokenContent)authDto.getData()).getUser());
      SessionUtils.setAccessToken(request, rpcAccessToken);
      response.put("token", rpcAccessToken.getAccessToken());
      response.put("userId", user.getId());
      response.put("username", user.getLoginName());
      response.put("alisname", user.getUserName());
      response.put("role", sysUserRoleService.listObjs(Wrappers.lambdaQuery(SysUserRole.class)
              .eq(SysUserRole::getUserid, user.getId()).select(SysUserRole::getRoleid), a -> (String)a));
      response.put("status", "OK");
      response.put("validateType", "ca");
      response.put("passwordPolicy", user.getPasswordPolicy());
      response.put("userCatalog", user.getUserCatalog());
    } catch (Exception ex) {
      ex.printStackTrace();
      return ResponseDataBase.error(ex.getMessage());
    } 
    return response;
  }
  
  public Result<SsoUser> validate(String UserCert) {
    try {
      SecurityEngineDeal sed = null;
      sed = SecurityEngineDeal.getInstance("SVSDefault");
      int retValue = sed.validateCert(UserCert);
      if (retValue == 1) {
        String sfz = sed.getCertInfoByOid(UserCert, "2.16.840.1.113732.2");
        if (StringUtils.isNotEmpty(sfz)) {
          sfz = sfz.substring(2);
          List<SysUser> users = this.sysUserService.queryList("certificateCode_EQ_" + sfz);
          if (users != null && users.size() > 0) {
            SysUser user = users.get(0);
            SsoUser ssoUser = new SsoUser();
            try {
              List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
              String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
              String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
              ssoUser.setId(user.getId());
              ssoUser.setUserid(user.getId());
              ssoUser.setUserName(user.getAname());
              ssoUser.setLoginName(user.getAccout());
              ssoUser.setRegionCode(regionCode);
              ssoUser.setRegionName(regionName);
              ssoUser.setUserCatalog(user.getCatalog());
              return Result.createSuccess(ssoUser);
            } catch (Exception e) {
              e.printStackTrace();
              throw new RuntimeException(e.getMessage());
            } 
          } 
        } 
      } else if (retValue == 0) {
        return Result.createError("验证时，发生未知错误，请联系管理员");
      } else if (retValue == -1) {
        return Result.createError("登录证书的根不被信任，请联系管理员");
      } else if (retValue == -2) {
        return Result.createError("登录证书超过有效期，请联系管理员");
      } else if (retValue == -3) {
        return Result.createError("登录证书为作废证书，请联系管理员");
      } else if (retValue == -4) {
        return Result.createError("登录证书被临时冻结，请联系管理员");
      } 
    } catch (Exception ex) {
      ex.printStackTrace();
    } 
    return null;
  }
}