package com.geoway.design.biz.service.login.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.design.base.constants.CommonConstants;
import com.geoway.design.biz.service.login.ISmsLoginService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author tanzl
 * @desc: 短信登录实现<br />
 * @date: 2025-01-17
 */
@Service
public class SmsCodeLoginImpl implements ISmsLoginService {
    @Value("${SMS.url}")
    private String smsURL;

    @Override
    public String getSmsCodeByTel(String tel) throws Exception {
        String res = HttpUtil.get(smsURL + "/zbph/sms/send/"+tel+"/1");
        return res;
    }

    @Override
    public boolean checkSmsCode(String tel, String code) throws Exception {
        String res = HttpUtil.get(smsURL + "/zbph/sms/check/sms-code/"+tel+"/1/"+code);
        JSONObject resJson = JSONObject.parseObject(res);
        if (CommonConstants.STATUS_SUCCESS!=resJson.getInteger("code")) {
            return false;
        }
        return true;
    }
    //TODO 湖南短信登录实现，可通过配置定义实现类
    /*@Override
    public String getSmsCodeByTel(String tel) throws Exception {
        Map<String, Object> map = new HashMap<>(8);
        map.put("phones", phones);
        map.put("customId", customId);
        map.put("content", content);
        String post = HttpUtil.post(smsURL + "/sms", map);
        return JSONObject.parseObject(post);
    }

    @Override
    public boolean checkSmsCode(String tel, String code) throws Exception {
        String res = HttpUtil.get(smsURL + "/zbph/sms/check/sms-code/"+tel+"/1/"+code);
        JSONObject resJson = JSONObject.parseObject(res);
        if (CommonConstants.STATUS_SUCCESS!=resJson.getInteger("code")) {
            return true;
        }
        return false;
    }*/
}
