package com.geoway.design.biz.service.login.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.service.login.ISsoAppService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.server.constant.TableFileds;
import com.geoway.sso.server.dto.App;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author ALMJ
 * @desc 应用权限验证逻辑
 */
@Service
public class SsoAppServiceImpl extends ServiceImpl<NsSystemMapper, SysNsSystem> implements ISsoAppService {

    @Autowired
    NsSystemMapper tbsysApplicationMapper;

    private List<App> appList = null;

    @Override
    public boolean exists(String appId) {
        this.appList = this._getAppList(appId, null);
        return appList.stream().anyMatch(app -> app.getAppId().equals(appId));
    }

    @Override
    public Result<Void> validate(String appId, String appSecret) {
        this.appList = this._getAppList(appId, appSecret);
        for (App app : appList) {
            if (app.getAppId().equals(appId)) {
                if (app.getAppSecret().equals(appSecret)) {
                    return Result.success();
                } else {
                    return Result.createError("appSecret有误");
                }
            }
        }
        return Result.createError("appId不存在");
    }

    /**
     * 按过滤条件获取APP列表
     *
     * @param appId
     * @param appScreet
     * @returnx`
     */
    private List<App> _getAppList(String appId, String appScreet) {
        List<App> resultAppList = new ArrayList<>();
        Iterable<SysNsSystem> applications = tbsysApplicationMapper.selectList(
                new QueryWrapper<SysNsSystem>()
                        .eq(TableFileds.SYS_SYSTEM_APP_KEY, appId)
                        .or()
                        .eq(TableFileds.SYS_SYSTEM_APP_SCRET, appScreet));

        Iterator itrApp = applications.iterator();
        while (itrApp.hasNext()) {
            SysNsSystem tab = (SysNsSystem) itrApp.next();
            App app = new App();
            app.setName(tab.getName());
            app.setAppId(tab.getAppKey());
            app.setAppSecret(tab.getAppSercet());
            resultAppList.add(app);
        }
        return resultAppList;
    }
}
