package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.biz.entity.BizManagerRange;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.vo.BizManagerVO;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
* @author wangqiang
* @description 针对表【sys_biz_manager_range】的数据库操作Service
* @createDate 2024-08-29 14:19:11
*/
public interface BizManagerRangeService extends IService<BizManagerRange> {
    void addBizManager(String userids);

    void delBizManager(String userids);

    IPage<BizManagerVO> queryBizManagerPage(String filterParam, Integer page, Integer size) throws Exception;

    void updateManage(String userid, Integer type, String values);

    List<BizManagerRange> queryManage(@RequestParam String userid,@RequestParam Integer type);

    List<String> queryAllManageOrgs(String userid);

    List<String> queryAllManageRegions(String userid);

    List<SysOrganization> queryOrgTree(String userid);
}
