package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysImage;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 应用
 * @author: wujing
 * @Date: 2021/10/31
 */
public interface IApplicationSysService extends IService<SysApplication> {

    void saveOrUp(SysApplication sysApplication,String groupId, MultipartFile file) throws Exception;

    void deleteApplication(String id) throws Exception;

    void deleteApplications(String ids) throws Exception;

    IPage<SysApplication> queryApplication(String params, Integer page, Integer size) throws Exception;

    List<SysApplication> queryList(String filterParam) throws Exception;

    List<SysApplication> queryListNoRelateRole(String filterParam,String roleId) throws  Exception;

    List<SysApplication> queryListNoRelatePermisson(String filterParam,String permissionId) throws  Exception;

    void saveGroup(SysGroup group) throws Exception;

    List<SysGroup> queryAppGroups() throws Exception;

    List<SysGroup> queryAppGroupsOnlyAdmin() throws Exception;

    void deleteGroup(String groupId) throws Exception;

    int queryAppCount() throws Exception;

    List<SysApplication> queryAppNoGroup(String userId);

    /**
    * @author daidongdong
    * @description 针对表【sys_image】的数据库操作Service
    * @createDate 2022-01-26 16:54:16
    */
    interface ISysImageService extends IService<SysImage> {

    }
}
