package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.dto.AppMenuDTO;
import com.geoway.design.biz.dto.FunctionDTO;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;

/**
 * 功能管理
 * @author: wujing
 * @Date: 2021/10/31
 */
public interface IFunctionSysService extends MPJBaseService<SysFunction>{

    void saveOrUp(SysFunction sysFunction) throws Exception;

    void deleteFunctionSys(String id,Integer sort,String pid,String appId) throws Exception;

    IPage<SysFunction> queryFunctionSys(String params, Integer page, Integer size, String uid, String userId) throws Exception;

    IPage<SysFunction> queryTree(String params, Integer page, Integer size) throws Exception;


    void upSort(String appId,String id,String pid ,Integer sort, Integer flag) throws Exception;

    List<SysApplication> queryFunctionTree();

    List<SysGroup> queryFunctionTreeByGroup() throws Exception;

    void updateInfo(SysFunction sysFunction);

    /**
     * 查询（一条）
     * @param id
     * @return
     */
    FunctionDTO queryInfo(String id);

    /**
    * @author daidongdong
    * @description 针对表【sys_user_security】的数据库操作Service
    * @createDate 2022-01-28 17:06:15
    */
    interface ISysUserSecurityService extends IService<SysUserSecurity> {

    }

    List<SysFunction> queryUserSysFunctions(String userId, SysApplication app);

    List<AppMenuDTO> queryAppMenus(String userId,String appId);

}
