package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.dto.UserSysDTO;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysNsSystem;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;

/**
 * 系统
 * @author: wujing
 * @Date: 2021/11/11
 */
public interface INsSystemService extends IService<SysNsSystem> {

    /**
     * 保存和编辑
     * @param sysNsSystem
     * @throws Exception
     */
    void saveOrUp(SysNsSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception;

    /**
     * 删除
     * @param id
     */
    void deleteSystem(String id) throws Exception;

    /**
     * 删除
     * @param ids
     */
    void deleteSystems(String ids) throws Exception;

    /**
     * 查询
     * @param key
     * @return
     */
    HashMap<String, Object> queryInfo(String key);


    /**
     * 查询列表
     * @param
     * @return
     */
    List<SysNsSystem> queryList() throws Exception;

    /**
     * 查询不在权限中的系统列表
     * @param permissonId
     * @return
     * @throws Exception
     */
    List<SysNsSystem> queryListNotInPermission(String permissonId) throws Exception;

    /**
     * 查询不在角色中的系统列表
     * @param roleId
     * @return
     * @throws Exception
     */
    List<SysNsSystem> queryListNotInRole(String roleId) throws Exception;

    /**
     * 查询所有
     * @param
     * @return
     */
    List<SysNsSystem> queryAll();

    /**
     * 状态管理
     * @param id
     * @param state
     */
    void stateUp(String id,Integer state);

    HashMap<String, Object> querySystemInfoByUser(String userId,String key);

    HashMap<String, Object> querySystemBaseInfoByKey(String key);

    /**
     * 查询用户授权的应用列表
     * @param userId 用户id
     * @return
     */
    List<SysNsSystem> querySystemListByUser(String userId);

    /**
     * 添加系统分组
     * @param group
     */
    void saveGroup(SysGroup group) throws Exception;

    /**
     * 查询系统分组
     * @return
     * @throws Exception
     */
    List<SysGroup> querySystemGroups(String userId) throws Exception;

    /**
     * 删除系统分组
     * @param groupId
     * @throws Exception
     */
    void deleteGroup(String groupId) throws Exception;

    /**
     * 查询没有分组的系统
     * @return
     */
    List<SysNsSystem> querySystemNoGroup(String userId) throws Exception;

    /**
     * 获取用户体系
     * @return
     */
    List<UserSysDTO> getUserSys();
}
