package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysPermission;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_permission】的数据库操作Service
* @createDate 2021-11-30 15:54:36
*/
public interface ISysPermissionService extends IService<SysPermission> {

    /**
     * 保存与编辑
     * @param
     * @throws Exception
     */
    void saveOrUp(SysPermission permission) throws Exception;

    IPage<SysPermission> queryByFilter(String params, Integer page, Integer size) throws Exception;

    /**
     * 查询权限关联菜单
     * @param id
     * @param systemId
     * @return
     */
    List<SysMenu>  queryRelateMenus(String id,String systemId);

    /**
     * 保存权限关联菜单
     * @param permissonId
     * @param systemId
     * @param menuIds
     */
    void saveRelateMenus(String permissonId,String systemId, List<String> menuIds);

    /**
     * 保存权限关联功能
     * @param permissonId
     * @param applicationId
     * @param functionIds
     */
    void saveRelateFunctions(String permissonId,String applicationId, List<String> functionIds);

    /**
     * 查询权限关联功能
     * @param id
     * @param applicationId
     * @return
     */
    List<SysFunction>  queryRelateFunctions(String id, String applicationId);

    /**
     * 删除权限
     * @param id
     * @throws Exception
     */
    void delete(String id) throws Exception;

    /**
     * 批量删除
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids) throws Exception;

    /**
     * 查询角色关联的权限信息
     * @param roleIds
     * @return
     */
    List<SysPermission> queryRolePermissons(String roleIds);


    /**
     * 查询角色关联的权限信息
     * @param roleIds
     * @return
     */
    List<SysPermission> queryRolePermissons(List<String> roleIds);

    /**
     *
     * @param permissonId
     * @param systemIds
     */
    void saveRelateSystems(String permissonId, List<String> systemIds,boolean isClear);

}
