package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role】的数据库操作Service
* @createDate 2021-11-25 18:51:53
*/
public interface ISysRoleService extends IService<SysRole> {

    /**
     * 保存与编辑
     * @param
     * @throws Exception
     */
    void saveOrUp(SysRole role) throws Exception;

    /**
     * 查询角色的树状结构
     * @return
     */
    List<SysRole> queryTree(String filterParam) throws Exception;

    /**
     * 根据过滤条件列表
     * @return
     */
    List<SysRole> queryList(String filterParam) throws Exception;

    /**
     * 查找上级
     * @return
     */
    List<SysRole> queryAllParentRole(String id);

    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception;

    /**
     * 根据角色查找对应权限
     * @param roleId
     * @return
     */
    List<SysPermission> queryPermissionByRoleId(String roleId);

    /**
     * 角色和用户相关联
     * @param roleId
     * @param permissionIds
     */
    void saveRolePermissions(String roleId,String permissionIds);

    /**
     * 查询角色信息（含直属子节点）
     * @param id
     * @param filterParam
     * @return
     */
    SysRole findOne(String id,String filterParam) throws Exception;


    /**
     * 批量删除
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids) throws Exception;

    /**
     * 查询用角色关联的用户
     * @param roleId
     * @return
     */
    List<SysUser> queryRelUsers(String roleId);
    /**
     * 查询用户关联角色
     *
     * @param userId
     * @return
     */
    List<SysRole> queryUserRoles(String userId);
    /**
     * 对同一目录下的角色进行排序
     * @param id
     * @param pid
     * @param flag
     */
    void sortRoles(String id,String pid,int flag);

    /**
     * 初始化排序
     * @param pid
     * @return
     */
    List<SysRole>  initSort(String pid);

    /**
     * 拖拽节点操作
     * @param id
     * @param targetId
     * @param type
     */
    void dragRoleNode(String id,String refId,String type) throws Exception;

    /**
     * 根据过滤条件查询个数
     * @return
     */
    int queryCount(String filterParam) throws Exception;


}
