package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysUserRole;

import java.util.List;
import java.util.Map;

/**
* @author daidongdong
* @description 针对表【sys_user_role】的数据库操作Service
* @createDate 2021-11-30 19:24:11
*/
public interface ISysUserRoleService extends IService<SysUserRole> {

    /**
     * 更新用户关联角色
     * @param userId
     * @param roleIds
     */
    public void updateUserRole(String userId, List<String> roleIds);

    /**
     * 更新角色关联用户
     * @param roleId
     * @param userIds
     */
    public void updateRoleUsers(String roleId, List<String> userIds);

    /**
     * 根据userid查询对应角色
     * @param ids
     * @return
     */
    Map<String,String> queryRoleByIds(List<String> ids);


}
