package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysApplicationGroup;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_application_group(应用分组)】的数据库操作Service
* @createDate 2022-12-14 17:48:31
*/
public interface SysApplicationGroupService extends IService<SysApplicationGroup> {

    /**
     * 保存应用所属分组
     * @param appId
     * @param groupId
     */
    void saveApplicationGroup(String appId,String groupId);

    /**
     * 移除应用所属分组
     * @param appId
     */
    void removeApplicationInGroup(String appId);

    /**
     * 移除应用所属分组
     * @param appId
     * @param groupId
     */
    void removeApplicationGroup(String appId,String groupId);

    /**
     * 查询分组里所属的应用id 列表
     * @param groupId
     * @return
     */
    List<String> queryGroupAppIds(String groupId);

    /**
     * 查询分组里所属的应用个数
     * @param groupId
     * @return
     */
    int queryCount(String groupId);

    /**
     * 查询 应用所属的分组列表
     * @param appIds
     * @return
     */
    List<String> queryAppGroupIds(List<String> appIds);

}
