package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.dto.RoleAppsDTO;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysRoleApplication;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_application(角色应用权限表)】的数据库操作Service
* @createDate 2024-10-15 17:25:14
*/
public interface SysRoleApplicationService extends IService<SysRoleApplication> {


    /**
     * 保存角色关联的应用
     * @param roleId
     * @param appIds
     * @param appType
     */
    void saveRoleApplications(String roleId, List<String> appIds,int appType,boolean isClear);

    /**
     * 保存角色关联的应用和系统
     * @param roleId
     * @param appIds
     * @param systemIds
     */
    void saveRoleAppsAndSysems(String roleId, List<String> appIds,List<String> systemIds,boolean isClear);

    /**
     * 查询角色关联的应用
     * @param roleId
     * @return
     */
    List<SysApplication> queryRoleApplications(String roleId);

    /**
     * 查询角色关联的系统
     * @param roleId
     * @return
     */
    List<SysNsSystem> queryRoleSystems(String roleId);

    /**
     * 查询角色关联的系统和应用
     * @param roleId
     * @return
     */
    RoleAppsDTO queryRoleAppsAndSystems(String roleId);

    /**
     * 删除角色关联的系统和应用
     * @param roleId
     * @param appIds
     * @param systemIds
     */
    void removeRoleAppsAndSysems(String roleId, List<String> appIds, List<String> systemIds);

}
