package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysRoleMenu;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_menu(角色关联菜单表)】的数据库操作Service
* @createDate 2024-10-15 17:25:14
*/
public interface SysRoleMenuService extends IService<SysRoleMenu> {

    /**
     * 查询角色关联的系统菜单
     * @param roleId
     * @param appId
     * @return
     */
    List<SysMenu> queryRelateMenus(String roleId, String appId);

    /**
     * 查询角色关联的应用菜单
     * @param roleId
     * @param appId
     * @return
     */
    List<SysFunction> queryRelateFunctions(String roleId, String appId);

    /**
     * 保存角色关联的系统和应用菜单
     * @param roleId
     * @param appId
     * @param appType
     * @param menuIds
     */
    void saveRoleMenus(String roleId, String appId, int appType,List<String> menuIds);

}
