package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.constatn.AppNodeType;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.constatn.RoleLevel;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.*;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import com.geoway.sso.client.util.HttpServletUtil;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用
 * @author: wujing
 * @Date: 2021/10/31
 */
@Service
public class ApplicationSysServiceImpl extends ServiceImpl<ApplicationSysMapper, SysApplication>
    implements IApplicationSysService {

    @Autowired
    FunctionSysMapper functionSysMapper;

    @Autowired
    ApplicationSysMapper applicationSysMapper;

    @Autowired
    INsMenuService menuService;

    @Autowired
    ISysImageService sysImageService;

    @Autowired
    SysGroupMapper sysGroupMapper;

    @Autowired
    SysApplicationGroupService sysApplicationGroupService;

    @Autowired
    SysUserMapper sysUserMapper;

    @Autowired
    IOauth2Service auth2Service;

    @Autowired
    SysUserApplicationService sysUserApplicationService;

    @Autowired
    SysRoleApplicationMapper sysRoleApplicationMapper;

    @Autowired
    SysPermissionApplicationMapper sysPermissionApplicationMapper;

    @Override
    public void saveOrUp(SysApplication sysApplication, String groupId,  MultipartFile file) throws Exception {
        //名称判断
        if(StringUtils.isEmpty(sysApplication.getName())){
            throw new Exception("应用名称为空！");
        }else {
            LambdaQueryWrapper<SysApplication> wrapper = Wrappers.lambdaQuery();
            //如果是编辑加上判断是
            if(StringUtils.isNotEmpty(sysApplication.getId())){
                wrapper.ne(SysApplication::getId, sysApplication.getId());
            }
            wrapper.eq(SysApplication::getName, sysApplication.getName());
            SysApplication one = applicationSysMapper.selectOne(wrapper);
            if(one!=null){
                throw new Exception("应用名称【"+one.getName()+"】已存在！");
            }
        }
        //标识判断
        if(StringUtils.isEmpty(sysApplication.getAppId())){
            throw new Exception("应用唯一标识为空！");
        }else {
            LambdaQueryWrapper<SysApplication> wrapper = Wrappers.lambdaQuery();
            //如果是编辑加上判断是
            if(StringUtils.isNotEmpty(sysApplication.getId())){
                wrapper.ne(SysApplication::getId, sysApplication.getId());
            }
            wrapper.eq(SysApplication::getAppId, sysApplication.getAppId());
            SysApplication one = applicationSysMapper.selectOne(wrapper);
            if(one!=null){
                throw new Exception("应用标识【"+one.getAppId()+"】已存在！");
            }
        }
        //排序字段
        if(StringUtils.isEmpty(sysApplication.getId())){
            int count = this.count();
            sysApplication.setSort(count);
        }
        boolean flag = this.saveOrUpdate(sysApplication);
        if(!flag){
            throw new Exception("保存失败！！！");
        }
        if(file != null && !file.isEmpty()){

            SysImage sysImage = sysImageService.getById(sysApplication.getImgid());
            if(sysImage == null ){
                sysImage = new SysImage();
                sysImage.setObjectid(sysApplication.getId());
                sysImage.setType(2);
            }

            sysImage.setImage(file.getBytes());
            sysImageService.saveOrUpdate(sysImage);
            if(StrUtil.isBlank(sysApplication.getImgid())){
                LambdaUpdateWrapper<SysApplication> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysApplication::getImgid,sysImage.getId());
                updateWrapper.eq(SysApplication::getId,sysApplication.getId());
                this.update(updateWrapper);
            }
        }

        if(StrUtil.isNotBlank(groupId)){
            sysApplicationGroupService.saveApplicationGroup(sysApplication.getId(),groupId);
        }

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.updateUserApplication(userId,sysApplication.getId(),AppType.application.getValue(), AppNodeType.node.getValue());
        }
    }

    @Override
    public void deleteApplication(String id) throws Exception {
        if(StringUtils.isEmpty(id)){
            throw new Exception("传递的【id】为空！");
        }
        //功能表删除
        LambdaQueryWrapper<SysFunction> funcWrappers = Wrappers.lambdaQuery();
        funcWrappers.eq(SysFunction::getAppId,id);
        //查询将要删除的功能
        List<String> ids = functionSysMapper.selectList(funcWrappers).stream().map(map ->  map.getId() ).collect(Collectors.toList());

        if(ids.size() > 0){
            int iCount = functionSysMapper.queryRelateMenesCount(ids);
            if(iCount > 0){
                throw new Exception("应用下存在挂接功能，不能删除");
            }
        }


        if(ids.size() > 0){
            //删除功能
            functionSysMapper.deleteBatchIds(ids);
            //修改菜单属性
            LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
            update.in(SysMenu::getFunctionId,ids).set(SysMenu::getType,0);
            menuService.update(update);
        }
        SysApplication sysApplication = this.getById(id);
        //删除应用关联的图片资源
        if(sysApplication !=null && StrUtil.isNotBlank(sysApplication.getImgid())){
            sysImageService.removeById(sysApplication.getImgid());
        }
        //删除应用所属分组
        if(sysApplication !=null){
            sysApplicationGroupService.removeApplicationInGroup(sysApplication.getId());
        }

        //删除应用
        this.removeById(id);

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.deleteExistApplication(userId,sysApplication.getId(),AppType.application.getValue());
        }
    }

    @Override
    public void deleteApplications(String ids) throws Exception {
        if(StringUtils.isEmpty(ids)){
            throw new Exception("传递的【id】为空！");
        }

        String[] idArr = ids.split(",");
        for(String id: idArr){
            this.deleteApplication(id);
        }
    }

    @Override
    public IPage<SysApplication> queryApplication(String params, Integer page, Integer size) throws Exception {
        if(StringUtils.isEmpty(params) && page == null){

            LambdaQueryWrapper<SysApplication> wrapper = Wrappers.lambdaQuery();
            wrapper.orderByDesc(SysApplication::getSort);

            int iCount = this.count();
            Page<SysApplication> pages = new Page<>(1,iCount);
            return this.page(pages,wrapper);
        }
        MyBatisQueryMapperUtils<SysApplication> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysApplication.class);
        Page<SysApplication> pages = new Page<>(page,size);
        return this.page(pages,queryWrapper);
    }

    @Override
    public List<SysApplication> queryList(String filterParam) throws Exception {

        MPJLambdaWrapper<SysApplication> queryWrapper = buildSysApplicationMPJLambdaWrapper(filterParam);
        return this.list(queryWrapper);
    }

    @Override
    public List<SysApplication> queryListNoRelateRole(String filterParam,String roleId) throws Exception {
        MPJLambdaWrapper<SysApplication> queryWrapper = buildSysApplicationMPJLambdaWrapper(filterParam);
        if(StrUtil.isNotBlank(roleId)){
            LambdaQueryWrapper<SysRoleApplication>  queryWrapper2 = Wrappers.lambdaQuery();
            queryWrapper2.eq(SysRoleApplication::getRoleid, roleId);

            List<SysRoleApplication> sysRoleApplications = sysRoleApplicationMapper.selectList(queryWrapper2);
            List<String> appIds = sysRoleApplications.stream().map(item -> item.getAppid()).collect(Collectors.toList());
            if(appIds.size() > 0){
                queryWrapper.notIn(SysApplication::getId,appIds);
            }
        }

        List<SysApplication> sysApplications = this.list(queryWrapper);

        return  sysApplications;
    }

    @Override
    public List<SysApplication> queryListNoRelatePermisson(String filterParam, String permissionId) throws Exception {
        MPJLambdaWrapper<SysApplication> queryWrapper = buildSysApplicationMPJLambdaWrapper(filterParam);
        if(StrUtil.isNotBlank(permissionId)){
            LambdaQueryWrapper<SysPermissonApplication>  queryWrapper2 = Wrappers.lambdaQuery();
            queryWrapper2.eq(SysPermissonApplication::getPermissionid, permissionId);

            List<SysPermissonApplication> sysPermissonApplications = sysPermissionApplicationMapper.selectList(queryWrapper2);
            List<String> appIds = sysPermissonApplications.stream().map(item -> item.getApplicationid()).collect(Collectors.toList());
            if(appIds.size() > 0){
                queryWrapper.notIn(SysApplication::getId,appIds);
            }
        }

        List<SysApplication> sysApplications = this.list(queryWrapper);

        return  sysApplications;
    }

    private MPJLambdaWrapper<SysApplication> buildSysApplicationMPJLambdaWrapper(String filterParam) throws Exception {
        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() == RoleLevel.commonUser.getValue()){
            throw  new Exception("用户无访问权限");
        }

        MPJQueryMapperUtil<SysApplication> qmu = new MPJQueryMapperUtil<>();
        MPJLambdaWrapper<SysApplication> queryWrapper = qmu.queryMapper(filterParam, SysApplication.class);
        queryWrapper.orderByAsc(SysApplication::getName);

        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            queryWrapper.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysNsSystem::getId);
            queryWrapper.eq(SysUserApplication::getApptype, AppType.application.getValue());
            queryWrapper.eq(SysUserApplication::getUserid, userId);
        }
        queryWrapper.orderByDesc(SysApplication::getSort);

        return queryWrapper;
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(2);

        LambdaQueryWrapper<SysGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType,2);
        queryWrapper.eq(SysGroup::getName,group.getName());

        if(StrUtil.isBlank(group.getId())){

            int icount = sysGroupMapper.selectCount(queryWrapper);
            if(icount > 0){
                throw  new Exception("分组名称: 【"+ group.getName() +"】 已存在");
            }

            sysGroupMapper.insert(group);
        }else{
            queryWrapper.ne(SysGroup::getId,group.getId());
            int icount = sysGroupMapper.selectCount(queryWrapper);
            if(icount > 0){
                throw  new Exception("分组名称: 【"+ group.getName() +"】 已存在");
            }

            sysGroupMapper.updateById(group);
        }

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.updateUserApplication(userId,group.getId(),AppType.application.getValue(),AppNodeType.group.getValue());
        }
    }

    @Override
    public List<SysGroup> queryAppGroups() throws Exception {

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() == RoleLevel.commonUser.getValue()){
            throw  new Exception("用户无访问权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();

        MPJLambdaWrapper<SysGroup> queryWrapper = new  MPJLambdaWrapper();
        queryWrapper.eq(SysGroup::getType,AppType.application.getValue());
        if(isBizAdmin){
            queryWrapper.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysGroup::getId);
            queryWrapper.eq(SysUserApplication::getUserid, userId);
            queryWrapper.eq(SysUserApplication::getApptype, AppType.application.getValue());
        }

        List<SysGroup> groups = sysGroupMapper.selectList(queryWrapper);
        List<String> groupIds = groups.stream().map(item -> item.getId()).collect(Collectors.toList());
        if(groupIds.size() > 0){
            MPJLambdaWrapper<SysApplication> queryWrapper2 =  MPJWrappers.lambdaJoin();
            queryWrapper2.selectAll(SysApplication.class);
            queryWrapper2.selectAs("ts",SysApplicationGroup::getGroupid, SysApplication::getGroupId);
            queryWrapper2.leftJoin(SysApplicationGroup.class, "ts",SysApplicationGroup::getAppid,SysApplication::getId);
            queryWrapper2.in(SysApplicationGroup::getGroupid, groupIds);

            if(isBizAdmin){
                queryWrapper2.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysApplication::getId);
                queryWrapper2.eq(SysUserApplication::getApptype, AppType.application.getValue());
                queryWrapper2.eq(SysUserApplication::getUserid, userId);
            }

            List<SysApplication> apps = this.list(queryWrapper2);

            for(SysGroup group:groups){
                List<SysApplication> subApps = apps.stream().filter(item -> group.getId().equals(item.getGroupId())).collect(Collectors.toList());
                //group.setApplications(this.queryByGroupId(group.getId()));
                group.setApplications(subApps);
            }
        }



        /*List<SysApplication> unGroupApps = this.queryAppNoGroup();
        if(unGroupApps.size() > 0){
            SysGroup group = new SysGroup();
            group.setId("weifenzu");
            group.setName("未分组");
            group.setType(2);

            group.setApplications(unGroupApps);
            groups.add(group);
        }*/

        return groups;
    }

    @Override
    public List<SysGroup> queryAppGroupsOnlyAdmin() throws Exception {

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() != RoleLevel.superAdmin.getValue()){
            throw  new Exception("用户无访问权限");
        }

        MPJLambdaWrapper<SysGroup> queryWrapper = new  MPJLambdaWrapper();
        queryWrapper.eq(SysGroup::getType,AppType.application.getValue());
        //queryWrapper.notExists();



        List<SysGroup> groups = sysGroupMapper.selectList(queryWrapper);
        List<String> groupIds = groups.stream().map(item -> item.getId()).collect(Collectors.toList());

        MPJLambdaWrapper<SysApplication> queryWrapper2 =  MPJWrappers.lambdaJoin();
        queryWrapper2.selectAll(SysApplication.class);
        queryWrapper2.selectAs("ts",SysApplicationGroup::getGroupid, SysApplication::getGroupId);
        queryWrapper2.leftJoin(SysApplicationGroup.class, "ts",SysApplicationGroup::getAppid,SysApplication::getId);
        queryWrapper2.in(SysApplicationGroup::getGroupid, groupIds);


        List<SysApplication> apps = this.list(queryWrapper2);

        for(SysGroup group:groups){
            List<SysApplication> subApps = apps.stream().filter(item -> group.getId().equals(item.getGroupId())).collect(Collectors.toList());
            //group.setApplications(this.queryByGroupId(group.getId()));
            group.setApplications(subApps);
        }

        return null;
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        List<String> appIds = sysApplicationGroupService.queryGroupAppIds(groupId);
        if(appIds.size() > 0){
            throw  new Exception("应用分组下有关联应用，不能删除");
        }
        sysGroupMapper.deleteById(groupId);

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.deleteGroupIsNoChild(userId,groupId,AppType.application.getValue());
        }
    }

    @Override
    public int queryAppCount(){
        int count = 0;
        LambdaQueryWrapper<SysGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType,2);

        List<SysGroup> groups = sysGroupMapper.selectList(queryWrapper);
        for(SysGroup group:groups){
            count += sysApplicationGroupService.queryCount(group.getId());
        }

        return count;
    }

    @Override
    public List<SysApplication> queryAppNoGroup(String userId) {
        return applicationSysMapper.queryAppNoGroup();
    }

    private List<SysApplication> queryByGroupId(String groupId){
        /*List<String> appIds = sysApplicationGroupService.queryGroupAppIds(groupId);
        if(appIds.size() > 0){
            return this.listByIds(appIds);
        }
        return new ArrayList<SysApplication>();*/
        return applicationSysMapper.queryAppsByGroupId(groupId);
    }

    private String getCurrentUserId(){
        HttpServletRequest request = HttpServletUtil.getRequest();

        return  auth2Service.queryCurrentUserId(request);
    }
}
