package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.design.base.support.BaseTreeUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.AppMenuDTO;
import com.geoway.design.biz.dto.FunctionDTO;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 应用
 *
 * @author: wujing
 * @Date: 2021/10/31
 */
@Service
public class FunctionSysServiceImpl extends MPJBaseServiceImpl<FunctionSysMapper, SysFunction>
        implements IFunctionSysService {

    final String rootPid = "1";
    private final TreeNodeConfig treeNodeConfig =
            new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

    @Autowired
    private FunctionSysMapper functionSysMapper;

    @Autowired
    private IApplicationSysService applicationSysService;

    @Override
    public void saveOrUp(SysFunction sysFunction) throws Exception {
        //名称判断
        if (StringUtils.isEmpty(sysFunction.getName())) {
            throw new Exception("功能名称为空！");
        } else {
            LambdaQueryWrapper<SysFunction> wrapper = Wrappers.lambdaQuery();
            //如果是编辑加上判断是否id
            if (StringUtils.isNotEmpty(sysFunction.getId())) {
                wrapper.ne(SysFunction::getId, sysFunction.getId());
            }
            wrapper.eq(SysFunction::getPid, sysFunction.getPid())
                    .eq(SysFunction::getAppId, sysFunction.getAppId())
                    .eq(SysFunction::getName, sysFunction.getName());
            SysFunction one = this.getOne(wrapper);
            if (one != null) {
                throw new Exception("功能名称【" + one.getName() + "】已存在！");
            }
        }
        //显示顺序
        if (StringUtils.isEmpty(sysFunction.getId())) {
            LambdaQueryWrapper<SysFunction> wrappers = Wrappers.lambdaQuery();
            wrappers.eq(SysFunction::getPid, sysFunction.getPid())
                    .eq(SysFunction::getAppId, sysFunction.getAppId())
                    .orderByAsc(true, SysFunction::getSort);
//            List<SysFunction> list = this.list();
            List<SysFunction> list = this.list(wrappers);
            int curSort = 1;
            if (list != null && list.size() > 0) {
                curSort = list.stream()
                        .reduce((prev, curr) -> prev.getSort() > curr.getSort() ? prev : curr)
                        .get().getSort();
                curSort++;
            }
            sysFunction.setSort(curSort);
            //默认值
            sysFunction.setNoLogin(0);
            sysFunction.setLinkOneMap(0);
        }
        //保存
        this.saveOrUpdate(sysFunction);
    }

    @Override
    public void deleteFunctionSys(String id, Integer sort, String pid, String appId) throws Exception {
        if (StringUtils.isEmpty(id)) {
            throw new Exception("传递的id为空！");
        }
        LambdaQueryWrapper<SysFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysFunction::getId, id).or().eq(SysFunction::getPid, id);
        //当前菜单和下面的子菜单都查出来
        List<SysFunction> sysFunctions = functionSysMapper.selectList(wrapper);
        //判断有无程序挂接
        List<String> funIds = sysFunctions.stream().map(i -> i.getId()).collect(Collectors.toList());
        if (funIds.size() > 0) {
            int iCount = functionSysMapper.queryRelateMenesCount(funIds);
            if (iCount > 0) {
                throw new Exception("该功能已经被挂接，不能删除");
            }
        }
        functionSysMapper.delete(wrapper);
//        调整排序
        upSortDelete(sort, pid, appId);
    }

    @Override
    public IPage<SysFunction> queryFunctionSys(String params, Integer page, Integer size, String uid, String userId) throws Exception {
        if (StringUtils.isEmpty(params) && page == null) {
            //查询所有
            Page<SysFunction> pages = new Page<>();
            LambdaQueryWrapper<SysFunction> wrapper = Wrappers.lambdaQuery();
            wrapper.orderByAsc(SysFunction::getSort);
            return this.page(pages, wrapper);
        }
        //条件查询
        MyBatisQueryMapperUtils<SysFunction> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysFunction.class);
        Page<SysFunction> pages = new Page<>(page, size);
        IPage pageInfo = this.page(pages, queryWrapper);
        return pageInfo;

    }

    @Override
    public IPage<SysFunction> queryTree(String params, Integer page, Integer size) throws Exception {
        MyBatisQueryMapperUtils<SysFunction> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = null;
        Page<SysFunction> pages = new Page<>(page, size);
        //模糊查询时需要从全部中查询然后父子节点关联
        if (params.indexOf("_LIKE_") > -1) {
            queryWrapper = qmu.queryMapper(params, SysFunction.class);
            queryWrapper.orderByAsc("f_sort");
            Page infos = this.page(pages, queryWrapper);
            List<SysFunction> records = infos.getRecords();
            pages.setRecords(getSearchTree(records, params));
        } else {
            //只查询一级目录
            String filterParam = "pid_EQ_1;" + params;
            queryWrapper = qmu.queryMapper(filterParam, SysFunction.class);
            queryWrapper.orderByAsc("f_sort");
            Page infos = this.page(pages, queryWrapper);
            List<SysFunction> records = infos.getRecords();
            //树形结构处理
            pages.setRecords(getTree(records, params));
        }
        return pages;
    }

    @Override
    public void upSort(String appId, String id, String pid, Integer sort, Integer flag) throws Exception {
        String errMsg = "排序失败!";
        LambdaQueryWrapper<SysFunction> wrapper = Wrappers.lambdaQuery();
        SysFunction funSys = this.getById(id);
        if (funSys == null) {
            return;
        }
        sort = funSys.getSort();
        switch (flag) {
            //上移
            case 1:
                wrapper.eq(SysFunction::getPid, pid)
                        .eq(SysFunction::getAppId, appId)
                        .lt(SysFunction::getSort, sort)
                        .orderByDesc(SysFunction::getSort);
                errMsg = "该功能已经置顶了!";
                break;
            //下移
            case 2:
                wrapper.eq(SysFunction::getPid, pid)
                        .eq(SysFunction::getAppId, appId)
                        .gt(SysFunction::getSort, sort)
                        .orderByAsc(SysFunction::getSort);
                errMsg = "该条记录已经置底了！";
                break;
        }
        SysFunction preInfo = this.list(wrapper).stream().findFirst().orElse(null);
        if (preInfo != null && !preInfo.getSort().equals(sort)) {
            //相互置换
            this.update(Wrappers.lambdaUpdate(SysFunction.class).eq(SysFunction::getId, id).set(SysFunction::getSort, preInfo.getSort()));
            this.update(Wrappers.lambdaUpdate(SysFunction.class).eq(SysFunction::getId, preInfo.getId()).set(SysFunction::getSort, sort));
        } else {
            wrapper.clear();
            wrapper.eq(SysFunction::getAppId, appId).eq(SysFunction::getPid, pid).eq(SysFunction::getSort, sort).ne(SysFunction::getId,id);
            int iCount = this.count(wrapper);
            if(iCount > 0){
                wrapper.clear();
                wrapper.eq(SysFunction::getAppId, appId).eq(SysFunction::getPid, pid).ne(SysFunction::getId, id);
                if(flag == 1) {
                    wrapper.ge(SysFunction::getSort, sort);
                }else if(flag == 2){
                    wrapper.le(SysFunction::getSort, sort);
                }else{
                    throw new Exception(errMsg);
                }
                wrapper.orderByAsc(SysFunction::getSort);
                List<SysFunction>  functions = this.list(wrapper);
                LambdaUpdateWrapper<SysFunction> updateWrapper = Wrappers.lambdaUpdate();
                int iSort = sort;
                if(flag == 2){
                    iSort = 0;
                    sort = functions.size() + 1;
                    funSys.setSort(sort);
                    updateWrapper.set(SysFunction::getSort,sort).eq(SysFunction::getId, funSys.getId());
                    this.update(updateWrapper);
                }

                for(SysFunction function: functions){
                    iSort++;
                    updateWrapper.clear();
                    updateWrapper.set(SysFunction::getSort,iSort).eq(SysFunction::getId, function.getId());
                    this.update(updateWrapper);
                }
                //throw new Exception(errMsg);
            }
        }
    }

    @Override
    public List<SysApplication> queryFunctionTree() {
        //查询所有一级应用
        List<SysApplication> list = applicationSysService.list();
        for (SysApplication application : list) {
            List<FunctionDTO> functionDTOS = functionSysMapper.queryFunctionTree("1", application.getId());
            application.setChildren(getFunctionTree(functionDTOS));
        }
        return list;
    }

    @Override
    public List<SysGroup> queryFunctionTreeByGroup() throws Exception {
        List<SysGroup> groups = applicationSysService.queryAppGroups();
        for(SysGroup group:groups){
            List<SysApplication> list = group.getApplications();
            for (SysApplication application : list) {
                List<FunctionDTO> functionDTOS = functionSysMapper.queryFunctionTree("1", application.getId());
                application.setChildren(getFunctionTree(functionDTOS));
            }
        }
        return groups;
    }

    @Override
    public void updateInfo(SysFunction sysFunction) {
        this.updateById(sysFunction);
    }

    @Override
    public FunctionDTO queryInfo(String id) {
        return functionSysMapper.queryInfo(id);
    }

    @Override
    public List<AppMenuDTO> queryAppMenus(String userId,String appId) {

        LambdaQueryWrapper<SysApplication> appQuery = Wrappers.lambdaQuery();
        appQuery.eq(SysApplication::getAppId,appId);
        appQuery.last(" limit 1");

        SysApplication app = applicationSysService.getOne(appQuery);
        if(app == null){
            List<AppMenuDTO> appMenuDTOS = new ArrayList<>();
            return  appMenuDTOS;
        }


        List<SysFunction> allFunctions = queryUserSysFunctions(userId, app);
        return convertToAppMenuTree(allFunctions);
    }

    @Override
    public List<SysFunction> queryUserSysFunctions(String userId, SysApplication app) {
        MPJLambdaWrapper<SysFunction> queryWrapper = new MPJLambdaWrapper<>();
        queryWrapper.eq(SysFunction::getAppId, app.getId());
        queryWrapper.eq(SysFunction::getNoLogin, 1);
        queryWrapper.orderByAsc(SysFunction::getSort);

        //先查找免登录的菜单
        List<SysFunction>  noLoginFunctions = this.list(queryWrapper);

        Set<SysFunction> allFunctionSets = new HashSet<>();
        allFunctionSets.addAll(noLoginFunctions);

        //再查找授权的菜单
        List<SysFunction>  validFunctions = null;
        if(StrUtil.isNotBlank(userId)){
            queryWrapper.clear();
            queryWrapper.eq(SysFunction::getAppId, app.getId());
            queryWrapper.leftJoin(SysPermissionFunction.class,SysPermissionFunction::getFuncid,SysFunction::getId);
            queryWrapper.leftJoin(SysRolePermission.class, SysRolePermission::getPermissionid, SysPermissionFunction::getPermissionid);
            queryWrapper.leftJoin(SysUserRole.class,SysUserRole::getRoleid,SysRolePermission::getRoleid);
            queryWrapper.eq(SysUserRole::getUserid, userId);
            queryWrapper.orderByAsc(SysFunction::getSort);
            validFunctions = this.list(queryWrapper);
            if(validFunctions != null ){
                allFunctionSets.addAll(validFunctions);
            }
        }

        //增加角色之间关联菜单权限的菜单
        if(StrUtil.isNotBlank(userId)){
            queryWrapper.clear();
            queryWrapper.eq(SysFunction::getAppId, app.getId());
            queryWrapper.leftJoin(SysRoleMenu.class,SysRoleMenu::getMenuid,SysFunction::getId);
            queryWrapper.leftJoin(SysUserRole.class,SysUserRole::getRoleid,SysRoleMenu::getRoleid);
            queryWrapper.eq(SysUserRole::getUserid, userId);
            queryWrapper.orderByAsc(SysFunction::getSort);
            validFunctions = this.list(queryWrapper);
            if(validFunctions != null ){
                allFunctionSets.addAll(validFunctions);
            }
        }

        List<String> allPids = new ArrayList<>();

        this.queryAllPidsNoContains(allFunctionSets,allPids);
        if(allPids.size() > 0){
            List<SysFunction> pFunctions = this.listByIds(allPids);
            allFunctionSets.addAll(pFunctions);
        }


        List<SysFunction> allFunctions = CollectionUtil.newArrayList(allFunctionSets);
        return allFunctions;
    }

    private void queryAllPidsNoContains(Set<SysFunction> functions,List<String> pids){
        List newPids = new ArrayList();
        for(SysFunction function: functions){
            boolean exists = StrUtil.isNotBlank(function.getPid()) && !function.getPid().equals(rootPid);
            if( exists && !pids.contains(function.getPid())){
                newPids.add(function.getPid());
            }
        }
        pids.addAll(newPids);
        if(newPids.size() > 0){
            List<SysFunction> pFunctions = this.listByIds(newPids);
            Set<SysFunction> pFunctionSets = new HashSet<>();
            pFunctionSets.addAll(pFunctions);
            queryAllPidsNoContains(pFunctionSets,pids);
        }
    }

    private List<AppMenuDTO> convertToAppMenuTree( List<SysFunction>  functions){
        List<AppMenuDTO> appMenuDTOS = new ArrayList<>();
        for(SysFunction function: functions){

            AppMenuDTO appMenuDTO = new AppMenuDTO();
            appMenuDTO.setName(function.getName());
            appMenuDTO.setId(function.getId());
            appMenuDTO.setKey(function.getKey());
            appMenuDTO.setKey(UUID.randomUUID().toString());
            appMenuDTO.setRoutename(function.getKey());
            appMenuDTO.setPid(function.getPid());

            appMenuDTO.setNoLogin(function.getNoLogin());
            int linkType = function.getUrlType() == 2 ? 0: 1;
            appMenuDTO.setLink(linkType);
            appMenuDTO.setNewPage(function.getOpen());
            appMenuDTO.setParams(function.getParams());
            appMenuDTO.setSort(function.getSort());
            appMenuDTO.setPath(function.getUrl());

            appMenuDTOS.add(appMenuDTO);
        }

        List<AppMenuDTO> menuTrees =  BaseTreeUtil.listToTree(appMenuDTOS,treeNodeConfig,rootPid);
        this.buildTreeLevel(menuTrees,1);

        return  menuTrees;
    }

    private void buildTreeLevel( List<AppMenuDTO> menuTrees,int level){
        for(AppMenuDTO menu: menuTrees){
            menu.setLevel(level);
            if(menu.getChildren() != null && menu.getChildren().size() > 0){
                menu.setIsLeaf(0);
                this.buildTreeLevel(menu.getChildren(),level+1);
            }else {
                menu.setIsLeaf(1);
            }
        }

    }

    /**
     * 构造功能描述所需的树
     *
     * @param list
     * @return
     */
    private List<FunctionDTO> getFunctionTree(List<FunctionDTO> list) {
        for (FunctionDTO function : list) {
            List<FunctionDTO> functionDTOS = functionSysMapper.queryFunctionTree(function.getId(), function.getAppId());
            if (functionDTOS.size() > 0) {
                function.setChildren(getFunctionTree(functionDTOS));
            } else {
                function.setIsLeaf(1);
            }
        }
        return list;
    }

    /**
     * 构件树
     *
     * @param records
     * @return
     */
    private List<SysFunction> getTree(List<SysFunction> records, String filterParam) throws Exception {
        //构建
        MyBatisQueryMapperUtils<SysFunction> qmu = new MyBatisQueryMapperUtils<>();
        for (SysFunction record : records) {
            String myFilterParam = filterParam + ";pid_EQ_" + record.getId();
            QueryWrapper wrapper = qmu.queryMapper(myFilterParam, SysFunction.class);
            //查询条件
            wrapper.orderByAsc("f_sort");
            //查询的数据
            List<SysFunction> list = this.list(wrapper);
            //递归
            if (list.size() > 0) {
                record.setChildren(getTree(list, filterParam));
            }
        }
        return records;
    }


    private List<SysFunction> getSearchTree(List<SysFunction> records, String filterParam) throws Exception {
        MyBatisQueryMapperUtils<SysFunction> qmu = new MyBatisQueryMapperUtils<>();
        //将pid为1的根节点和其他子节点区分到一个map
        Map<Boolean, List<SysFunction>> recordMap = records.stream()
                .collect(Collectors.partitioningBy(v -> "1".equals(v.getPid())));
        List<SysFunction> parents = getTree(recordMap.get(true), filterParam);
        List<SysFunction> childs = recordMap.get(false);
        return Stream.of(parents, childs)
                .flatMap(x -> x.stream())
                .collect(Collectors.toList());
    }

    /**
     * 显示顺序调整
     *
     * @param sort
     * @param id
     */
    private void upSort(String appId, Integer sort, String id, String pid) {
        //根据sort查询
        LambdaQueryWrapper<SysFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysFunction::getSort, sort)
                .eq(SysFunction::getAppId, appId)
                .eq(SysFunction::getPid, pid);
        SysFunction one = this.getOne(wrapper);
        //判断是否需要调整
        if (one != null && !one.getId().equals(id)) {
            //获取最大值
            Integer maxSort = functionSysMapper.findMaxSort(pid);
            //循环增加
            for (int i = maxSort; i >= sort; i--) {
                UpdateWrapper<SysFunction> updateWrapper = Wrappers.update();
                updateWrapper.eq("f_sort", i)
                        .eq("f_pid", pid)
                        .set("f_sort", i + 1);
                this.update(updateWrapper);
            }
        }
    }

    /**
     * 显示顺序调整（删除）
     */
    private void upSortDelete(Integer sort, String pid, String appId) {
        //获取最大值
//        Integer maxSort = functionSysMapper.findMaxSort(pid);
        QueryWrapper<SysFunction> wrapper = new QueryWrapper<>();
        wrapper.eq("f_pid", pid)
                .eq("f_appid", appId);
        List<SysFunction> list = this.list(wrapper);
        if (list.size() > 0) {
            if (sort < list.get(0).getSort()) {
                //循环递减
                for (int i = sort + 1; i <= list.get(0).getSort(); i++) {
                    UpdateWrapper<SysFunction> updateWrapper = Wrappers.update();
                    updateWrapper.eq("f_sort", i)
                            .eq("f_pid", pid)
                            .set("f_sort", i - 1);
                    this.update(updateWrapper);
                }
            }
        }
    }

}
