package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.BaseTreeUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.*;
import com.geoway.design.biz.service.dev.IUrlDynamicParameterService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.vo.SysMenuVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 导航信息
 *
 * @author: wujing
 * @Date: 2021/11/11
 */
@Service
public class NsMenuServiceImpl extends ServiceImpl<SysMenuMapper, SysMenu>
        implements INsMenuService {

    final String rootPid = "1";
    private final TreeNodeConfig treeNodeConfig =
            new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");


    @Autowired
    private FunctionSysMapper functionSysMapper;

    @Autowired
    private ApplicationSysMapper applicationSysMapper;
    @Autowired
    private IUrlDynamicParameterService urlDynamicParameterService;
    @Autowired
    private NsSystemMapper systemMapper;
    @Autowired
    private SysFunctionServerRoutesMapper sysFunctionServerRoutesMapper;

    @Override
    public void saveOrUp(SysMenu menuSys) throws Exception {
        if (StringUtils.isEmpty(menuSys.getName())) {
            throw new Exception("名称不能为空");
        }
        if (StringUtils.isEmpty(menuSys.getKey())) {
            throw new Exception("关键字不能为空");
        }

        //判断名称和key是否重复(在同一系统中)
        LambdaQueryWrapper<SysMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, menuSys.getSystemId());

        //无id就是新增
        if (StrUtil.isBlank(menuSys.getId())) {
            //排序
            LambdaQueryWrapper<SysMenu>  countQueryWrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysMenu::getSystemId, menuSys.getSystemId());
            countQueryWrapper.eq(SysMenu::getPid, menuSys.getPid());

            Integer sort = this.count(countQueryWrapper)+1;
            menuSys.setSort(sort);
        } else {
            //名称不等于自己的
            wrapper.ne(SysMenu::getId, menuSys.getId());
        }

        //LambdaQueryWrapper<SysMenu> wrapperKey = wrapper.clone();
        wrapper.eq(SysMenu::getKey, menuSys.getKey());


        int iCountKey = this.count(wrapper);
        if (iCountKey > 0) {
            throw new Exception("菜单关键字:" + menuSys.getKey() + " 已存在！");
        }

        //上级type类型变更
        if (StringUtils.isEmpty(menuSys.getId()) && !menuSys.getPid().equals(rootPid)) {
            LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
            update.eq(SysMenu::getId, menuSys.getPid())
                    .set(SysMenu::getType, 1);
            this.update(update);
        }
        //保存
        this.saveOrUpdate(menuSys);

    }

    @Override
    public List<SysMenu> queryTree(String systemId, Integer flag, Integer group) {
        //获取所有一级菜单
        LambdaQueryWrapper<SysMenu> wrapper = Wrappers.lambdaQuery();
        String pid = rootPid;
        wrapper.eq(SysMenu::getPid, pid)
                .orderByAsc(SysMenu::getSort);
        //判断是否有key 不是的就查询所有
        if (StringUtils.isNotEmpty(systemId)) {
            wrapper.eq(SysMenu::getSystemId, systemId);
        }

        //若指定了菜单分组则只查询此组里中的菜单
        if (group != null) {
            wrapper.eq(SysMenu::getGroup, group);
        }

        List<SysMenu> list = this.list(wrapper);
        return getTree(list, flag);
    }


    @Override
    public void deleteMenu(String id, String pid) throws Exception {
        //判断是否存在子节点
        Integer count = this.count(new QueryWrapper<SysMenu>().eq("f_pid", id));
        if (count > 0) {
            throw new Exception("存在子菜单,无法删除！");
        }
        QueryWrapper<SysMenu> wrapper = new QueryWrapper<>();
        //根据id
        if (StringUtils.isNotEmpty(id)) {
            wrapper.eq("f_id", id);
        }
        SysMenu sysMenu = this.getOne(wrapper);
        if (sysMenu != null && StrUtil.isNotEmpty(sysMenu.getFunctionId())) {
            throw new Exception("菜单已挂接功能,无法删除,请取消挂接功能再试试！");
        }
        this.getBaseMapper().delete(wrapper);
        //修改上级菜单类型
        if (!rootPid.equals(pid)) {
            LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
            update.eq(SysMenu::getId, pid)
                    .set(SysMenu::getType, 0);
            this.update(update);
        }
    }

    @Override
    public void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception {
        SysMenu menu = this.getById(id);
        if (menu == null) {
            return;
        }
        sort = menu.getSort();
        int otherSort = sort;
        if (flag != null) {
            //查询最小的记录
            LambdaUpdateWrapper<SysMenu> queryWrapper = Wrappers.lambdaUpdate();
            switch (flag) {
                //置顶
                case 1:
                    queryWrapper.eq(SysMenu::getPid, pid).eq(SysMenu::getSystemId, systemId).orderByAsc(SysMenu::getSort)
                            .last("limit 1");
                    SysMenu minInfo = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (minInfo != null && !minInfo.getSort().equals(sort)) {
                        Integer min = minInfo.getSort();
                        --sort;
                        //排序+1
                        for (; sort >= min; sort--) {
                            updateSort(pid, systemId, sort, sort + 1);
                        }
                        //置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, min));
                    } else {
                        throw new Exception("该条记录已经置顶了！");
                    }
                    break;
                //上移
                case 2:
                    //查询排序小一位的记录
                    queryWrapper.eq(SysMenu::getPid, pid)
                            .eq(SysMenu::getSystemId, systemId)
                            .lt(SysMenu::getSort, sort)
                            .orderByDesc(SysMenu::getSort);
                    SysMenu info = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (info != null && !info.getSort().equals(sort)) {
                        //相互置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, info.getSort()));
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, info.getId()).set(SysMenu::getSort, sort));
                    } else {
                        throw new Exception("该条记录已经置顶了！");
                    }
                    break;
                //下移
                case 3:
                    //查询排序大一位的记录
                    queryWrapper.eq(SysMenu::getPid, pid)
                            .eq(SysMenu::getSystemId, systemId)
                            .gt(SysMenu::getSort, sort)
                            .orderByAsc(SysMenu::getSort);
                    SysMenu one = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (one != null && !one.getSort().equals(sort)) {
                        //相互置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, one.getSort()));
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, one.getId()).set(SysMenu::getSort, sort));
                    } else {
                        throw new Exception("该条记录已经置底了！");
                    }
                    break;
                //置底
                case 4:
                    //查询最大的记录
                    queryWrapper.eq(SysMenu::getPid, pid).eq(SysMenu::getSystemId, systemId).orderByDesc(SysMenu::getSort)
                            .last("limit 1");
                    SysMenu maxInfo = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (maxInfo != null && !maxInfo.getSort().equals(sort)) {
                        Integer max = maxInfo.getSort();
                        ++sort;
                        //排序-1
                        for (; sort <= max; sort++) {
                            updateSort(pid, systemId, sort, sort - 1);
                        }
                        //置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, max));
                    } else {
                        throw new Exception("该条记录已经置底了！");
                    }
                    break;
                default:
                    break;
            }

        }
    }

    @Override
    public void updateType(String id, Integer type, String fid, Integer funType) {
        //修改菜单类型
        LambdaUpdateWrapper<SysMenu> queryWrapper = new UpdateWrapper().lambda();
        queryWrapper.eq(SysMenu::getId, id)
                .set(SysMenu::getType, type)
                .set(SysMenu::getFunctionId, fid)
                .set(SysMenu::getFuntype, funType);
        this.update(queryWrapper);
    }

    @Override
    public void updateDefault(String id, String sid) {
        //设置默认
        LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
        update.eq(SysMenu::getId, id)
                .set(SysMenu::getIsdefault, 1);
        this.update(update);
        //清空条件
        update.clear();
        //取消原默认菜单
        update.eq(SysMenu::getIsdefault, 1)
                .eq(SysMenu::getSystemId, sid)
                .ne(SysMenu::getId, id)
                .set(SysMenu::getIsdefault, 0);
        this.update(update);
    }

    @Override
    public List<SysMenu> queryUserMenuTree(String userId, String systemId, Integer flag, Integer group) {
        List<SysMenu> menus = querySysMenus(userId, systemId, flag, group);
        //List<SysMenu> menuTrees = this.bulidTree(menuSet);
        List<SysMenu> menuTrees = BaseTreeUtil.listToTree(menus, treeNodeConfig, rootPid);
        return menuTrees;
    }

    private List<SysMenu> querySysMenus(String userId, String systemId, Integer flag, Integer group) {
        List<SysMenu> menus = new ArrayList<>();
        List<SysMenu>  noLoginMenus = this.getBaseMapper().querySystemMenuNoLogin(systemId, group);
        menus.addAll(noLoginMenus);
        //先查找免登录菜单，再查找登录菜单权限
        if(StrUtil.isNotBlank(userId)){

            //1.先查找用户-角色-权限-菜单 关联的菜单
            List<SysMenu>  userMenus1 = this.getBaseMapper().queryUserSystemMenu(userId, systemId, group);
            //2.再查找用户-角色-菜单权限的菜单
            List<SysMenu>  userMenus2 = this.getBaseMapper().queryUserSystemMenuByRole(userId, systemId, group);

            userMenus1.addAll(userMenus2);
            boolean isExsists = false;
            for(SysMenu userMenu: userMenus1){
                isExsists = menus.stream().anyMatch( item -> item.getId().equals(userMenu.getId()));
                if(!isExsists){
                    menus.add(userMenu);
                }
            }
        }

        List<String> allPids = new ArrayList<>();
        this.queryAllPidsNoContains(menus,allPids);
        List<String> allIds = menus.stream().map(menuItem -> menuItem.getId()).collect(Collectors.toList());
        List<String> filterPids = allPids.stream().filter( pid -> !allIds.contains(pid) ).collect(Collectors.toList());
        if(filterPids.size() > 0){
            List<SysMenu> pMenus = this.listByIds(filterPids);
            menus.addAll(pMenus);
        }

        List<SysApplication> applications=new ArrayList<>();
        Set<SysMenu> menuSet = new HashSet<>(menus);
        menus = new ArrayList<>(menuSet);
        for (SysMenu menuSys : menus) {
            //判断是否挂接功能
            if (flag == 1 && StringUtils.isNotEmpty(menuSys.getFunctionId())) {
                //如果是直接挂接功能菜单
                if (menuSys.getFuntype() != null && menuSys.getFuntype() == 2) {
                    SysApplication app = applicationSysMapper.selectById(menuSys.getFunctionId());
                    applications.add(app);
                    if (app != null) {
                        menuSys.setUrl(urlDynamicParameterService.replace(app.getUrl()));
                    }
                } else {
                    //查询并存储
                    SysFunction one = functionSysMapper.selectById(menuSys.getFunctionId());
                    menuSys.setFunctionInfo(one);
                    if(one==null){
                        continue;
                    }
                    if(HttpUtil.isHttp(one.getUrl())||HttpUtil.isHttps(one.getUrl())){
                        one.setUrl(urlDynamicParameterService.replace(one.getUrl()));
                        menuSys.setUrl(one.getUrl());
                        continue;
                    }
                    SysApplication application=applications.stream().filter(f->f.getAppId().equals(one.getId())).findAny().orElse(null);
                    if(application==null){
                        application=applicationSysMapper.selectById(one.getAppId());
                        applications.add(application);
                        if(StringUtils.isNotEmpty(application.getUrl())){
                            one.setUrl(application.getUrl()+one.getUrl());
                        }
                    }
                    one.setUrl(urlDynamicParameterService.replace(one.getUrl()));
                    menuSys.setUrl(one.getUrl());
                }

            }
        }
        return menus;
    }

    private void queryAllPidsNoContains(List<SysMenu> menus,List<String> pids){
        List newPids = new ArrayList();
        for(SysMenu menu: menus){
            boolean exists = StrUtil.isNotBlank(menu.getPid()) && !menu.getPid().equals(rootPid);
            if( exists && !pids.contains(menu.getPid())){
                newPids.add(menu.getPid());
            }
        }
        pids.addAll(newPids);
        if(newPids.size() > 0){
            List<SysMenu> pMenus = this.listByIds(newPids);
            queryAllPidsNoContains(pMenus,pids);
        }
    }

    /**
     * 获取菜单
     *
     * @param roleIdList 角色id
     * @return {@link List}<{@link Tree}<{@link String}>>
     */
    @Override
    public List<Tree<String>> getSysMenuVoTree(List<String> roleIdList) {
        List<Tree<String>> treeList = new ArrayList<>();
        List<SysMenuVO> sysMenuVOList = baseMapper.getSysMenuVO(roleIdList);
        if (ObjectUtil.isNotEmpty(sysMenuVOList)) {
            return BaseTreeUtil.ListBuildTree(sysMenuVOList, SysMenuVO.class, treeNodeConfig, rootPid);
        }
        return treeList;
    }

    @Override
    public SysMenu queryMenuByKey(String menuKey, String systemId) {
        LambdaQueryWrapper<SysMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId,systemId);
        wrapper.eq(SysMenu::getKey,menuKey);
        wrapper.last("LIMIT 1");

        SysMenu menu = this.getOne(wrapper);
        if(menu != null){
            if(menu.getLevel() == 1){
                menu.setRootId(menu.getId());
            }else if(menu.getLevel() == 2){
                menu.setRootId(menu.getPid());
            }else if(menu.getLevel() == 3){
                SysMenu pMenu = this.getById(menu.getPid());
                menu.setRootId(pMenu.getPid());
            }
        }
        return menu;
    }

    @Override
    public List<String> querySystemServerRouteKeys(String userId, List<String> systemKey) {
        List<SysMenu> menus = new ArrayList<>();
        List<String> serverRouteKeys = new ArrayList<>();

        LambdaQueryWrapper<SysNsSystem> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(SysNsSystem::getKey,systemKey);
        //queryWrapper.last(" limit 1");

        List<SysNsSystem> systems = systemMapper.selectList(queryWrapper);
        if(systems == null||systems.size()==0){
            return  serverRouteKeys;
        }
        for(SysNsSystem system:systems) {
            int group = 0;
            String systemId = system.getId();
            List<SysMenu> noLoginMenus = this.getBaseMapper().querySystemMenuNoLogin(systemId, group);
            menus.addAll(noLoginMenus);
            //先查找免登录菜单，再查找登录菜单权限
            if (StrUtil.isNotBlank(userId)) {

                //1.先查找用户-角色-权限-菜单 关联的菜单
                List<SysMenu> userMenus1 = this.getBaseMapper().queryUserSystemMenu(userId, systemId, group);
                //2.再查找用户-角色-菜单权限的菜单
                List<SysMenu> userMenus2 = this.getBaseMapper().queryUserSystemMenuByRole(userId, systemId, group);

                userMenus1.addAll(userMenus2);
                boolean isExsists = false;
                for (SysMenu userMenu : userMenus1) {
                    isExsists = menus.stream().anyMatch(item -> item.getId().equals(userMenu.getId()));
                    if (!isExsists) {
                        menus.add(userMenu);
                    }
                }
            }
        }
        List<String> functionIds = new ArrayList<>();
        for(SysMenu menu: menus){
            if(StrUtil.isNotBlank(menu.getFunctionId())){
                functionIds.add(menu.getFunctionId());
            }
        }

        if(functionIds.size() == 0){
            return  serverRouteKeys;
        }

        LambdaQueryWrapper<SysFunctionServerRoutes> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.in(SysFunctionServerRoutes::getFunctionid,functionIds);

        List<SysFunctionServerRoutes> serverRoutes =  sysFunctionServerRoutesMapper.selectList(queryWrapper2);
        serverRouteKeys = serverRoutes.stream().map(i -> i.getRoutekey()).collect(Collectors.toList());


        return serverRouteKeys;
    }



    @Override
    public List<String> querySystemServerRouteKeys(String userId, String systemKey) {

       return querySystemServerRouteKeys(userId, CollectionUtil.newArrayList(systemKey));
    }

    private List<SysMenu> bulidTree(Set<SysMenu> menus) {
        int minLevel = 99;
        Map<String, List<SysMenu>> mapParam = new HashMap<>();
        for (SysMenu menu : menus) {
            String key = menu.getPid();
            if (!StringUtils.isEmpty(key) && !key.equals(rootPid)) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(menu);
                } else {
                    List<SysMenu> childList = new ArrayList<>();
                    childList.add(menu);
                    mapParam.put(key, childList);
                }
            }

            if (menu.getLevel() < minLevel) {
                minLevel = menu.getLevel();
            }
        }
        List<SysMenu> results = new ArrayList<>();
        for (SysMenu menu : menus) {
            String key = menu.getId();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                List<SysMenu> child = menuSort(mapParam.get(key));
                menu.setChildren(child);
            }
            if (menu.getLevel() == minLevel) {
                results.add(menu);
            }
        }
        return menuSort(results);
    }

    /**
     * 排序修改
     *
     * @param pid
     * @param systemId
     * @param sort
     * @param value
     */
    private void updateSort(String pid, String systemId, Integer sort, Integer value) {
        LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
        update.eq(SysMenu::getPid, pid)
                .eq(SysMenu::getSystemId, systemId)
                .eq(SysMenu::getSort, sort)
                .set(SysMenu::getSort, value);
        this.update(update);
    }

    /**
     * 递归查询树
     *
     * @param list
     * @return
     */
    private List<SysMenu> getTree(List<SysMenu> list, Integer flag) {
        for (SysMenu menuSys : list) {
            //判断是否挂接功能
            if (flag == 1 && StringUtils.isNotEmpty(menuSys.getFunctionId())) {
                //查询并存储
                SysFunction one = functionSysMapper.selectById(menuSys.getFunctionId());
                menuSys.setFunctionInfo(one);
            }
            //查询是否有子菜单
            List<SysMenu> children = this.list(new QueryWrapper<SysMenu>().eq("f_pid", menuSys.getId()).orderByAsc("f_sort"));
            if (children.size() > 0) {
                //进行递归并赋值
                menuSys.setChildren(getTree(children, flag));
            }
        }
        return list;
    }

    /**
     * 按level、sort字段排序菜单
     *
     * @param menuList
     * @return
     */
    private List<SysMenu> menuSort(List<SysMenu> menuList) {
        Collections.sort(menuList, new Comparator<SysMenu>() {
            @Override
            public int compare(SysMenu menu1, SysMenu menu2) {
                int flag;
                // 先按level降序排序
                flag = menu1.getLevel() - menu2.getLevel();
                if (flag == 0) {
                    //再按sort降序排序
                    flag = menu1.getSort() - menu2.getSort();
                }
                return flag;
            }
        });
        return menuList;
    }
}
