package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.config.SsoConfigProp;
import com.geoway.design.base.enums.UserSysEnum;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.constatn.AppNodeType;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.constatn.RoleLevel;
import com.geoway.design.biz.dto.UserSysDTO;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.*;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import com.geoway.sso.client.util.HttpServletUtil;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 系统
 *
 * @author: wujing
 * @Date: 2021/11/15
 */
@Service
public class NsSystemServiceImpl extends ServiceImpl<NsSystemMapper, SysNsSystem>
        implements INsSystemService {

    @Autowired
    private NsSystemMapper systemMapper;

    @Autowired
    private SysMenuMapper menuMapper;

    @Autowired
    private NsMenuServiceImpl menuService;

    @Autowired
    private ProjectConfig config;

    @Autowired
    private NsSystemStyleServiceImpl styleService;

    @Autowired
    IApplicationSysService.ISysImageService sysImageService;

    @Autowired
    SysGroupMapper sysGroupMapper;

    @Autowired
    SysUserMapper sysUserMapper;

    @Autowired
    SysPermissionSystemMapper sysPermissionSystemMapper;

    @Autowired
    IOauth2Service auth2Service;

    @Autowired
    SysUserApplicationService sysUserApplicationService;

    @Autowired
    SysRoleApplicationMapper sysRoleApplicationMapper;
    @Autowired
    private SsoConfigProp ssoConfig;

    @Override
    public void saveOrUp(SysNsSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception{
        //空值判断 and 重复判断
        if (StringUtils.isEmpty(sysNsSystem.getName())) {
            throw new Exception("【名称】不能为空！");
        } else {
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysNsSystem::getName, sysNsSystem.getName());
            //有id的时候是编辑，不查询本身
            if (StringUtils.isNotEmpty(sysNsSystem.getId())) {
                wrapper.ne(SysNsSystem::getId, sysNsSystem.getId());
            }
            SysNsSystem one = this.getOne(wrapper);
            if (one != null) {
                throw new Exception("名称【" + one.getName() + "】已存在！");
            }
        }
        if (StringUtils.isEmpty(sysNsSystem.getStyleId())) {
            throw new Exception("【主题】不能为空！");
        }
        if (StringUtils.isEmpty(sysNsSystem.getKey())) {
            throw new Exception("【关键字】不能为空！");
        } else {
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysNsSystem::getKey, sysNsSystem.getKey());
            //有id的时候是编辑，不查询本身
            if (StringUtils.isNotEmpty(sysNsSystem.getId())) {
                wrapper.ne(SysNsSystem::getId, sysNsSystem.getId());
            }
            SysNsSystem one = this.getOne(wrapper);
            if (one != null) {
                throw new Exception("关键字【" + one.getKey() + "】已存在！");
            }
        }
        /*if (StringUtils.isEmpty(sysNsSystem.getImgUrl())) {
            throw new Exception("【系统logo】不能为空！");
        }*/
        if (StringUtils.isEmpty(sysNsSystem.getId())) {
            //排序
            int cur = this.count();
            sysNsSystem.setSort(++cur);
            //时间
            sysNsSystem.setUpDateTime(new Date());
        }else{
            sysNsSystem.setSort(sysNsSystem.getSort());
            sysNsSystem.setUpDateTime(sysNsSystem.getUpDateTime());
        }

        SysNsSystem exsitSystem=getById(sysNsSystem.getId());

        //保存
        this.saveOrUpdate(sysNsSystem);

        if(logofile != null && !logofile.isEmpty()){

            SysImage sysImage = sysImageService.getById(sysNsSystem.getLogoid());
            if(sysImage == null ){
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }

            sysImage.setImage(logofile.getBytes());
            sysImageService.saveOrUpdate(sysImage);
            if(StrUtil.isBlank(sysNsSystem.getLogoid())){
                LambdaUpdateWrapper<SysNsSystem> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getLogoid,sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId,sysNsSystem.getId());
                this.update(updateWrapper);
            }
        }else if(StrUtil.isBlankIfStr(sysNsSystem.getLogoid())
                &&exsitSystem!=null
                && StrUtil.isNotBlank(exsitSystem.getLogoid())){
           //前端定义的删除逻辑：图片为空，并且id为空，则删除
            sysImageService.removeById(exsitSystem.getLogoid());
        }

        if(bgfile != null && !bgfile.isEmpty()){

            SysImage sysImage = sysImageService.getById(sysNsSystem.getBgid());
            if(sysImage == null ){
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }

            sysImage.setImage(bgfile.getBytes());
            sysImageService.saveOrUpdate(sysImage);
            if(StrUtil.isBlank(sysNsSystem.getBgid())){
                LambdaUpdateWrapper<SysNsSystem> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getBgid,sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId,sysNsSystem.getId());
                this.update(updateWrapper);
            }
        }
        else if(StrUtil.isBlankIfStr(sysNsSystem.getBgid())
                &&exsitSystem!=null
                && StrUtil.isNotBlank(exsitSystem.getBgid())){
            //前端定义的删除逻辑：图片为空，并且id为空，则删除
            sysImageService.removeById(exsitSystem.getBgid());
        }

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.updateUserApplication(userId,sysNsSystem.getId(),AppType.system.getValue(), AppNodeType.node.getValue());
        }
    }

    @Override
    public void deleteSystem(String id) throws Exception {

        SysNsSystem sysNsSystem = this.getById(id);
        //删除应用关联的图片资源
        if(sysNsSystem !=null && StrUtil.isNotBlank(sysNsSystem.getLogoid())){
            sysImageService.removeById(sysNsSystem.getLogoid());
        }
        if(sysNsSystem !=null && StrUtil.isNotBlank(sysNsSystem.getBgid())){
            sysImageService.removeById(sysNsSystem.getBgid());
        }
        //删除应用
        this.removeById(id);
        //级联删除菜单
        LambdaQueryWrapper<SysMenu> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysMenu::getSystemId, sysNsSystem.getId());
        menuMapper.delete(menuWrapper);

        //删除应用关联的权限信息
        LambdaQueryWrapper<SysPermissonSystem> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysPermissonSystem::getSystemid, sysNsSystem.getId());
        sysPermissionSystemMapper.delete(queryWrapper2);

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.deleteExistApplication(userId,sysNsSystem.getId(),AppType.system.getValue());
        }

    }

    @Override
    public void deleteSystems(String ids) throws Exception {
        if(StrUtil.isBlank(ids)){
            return;
        }
        String[] idArr = ids.split(",");
        for(String id: idArr){
            this.deleteSystem(id);
        }
    }

    @Override
    public HashMap<String, Object> queryInfo(String key) {
        HashMap<String, Object> map = new HashMap<>();
        if (StringUtils.isNotEmpty(key)) {
            //查询系统信息
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysNsSystem::getKey, key)
                    .eq(SysNsSystem::getState, 1);
            SysNsSystem sysNsSystem = this.getOne(wrapper);
            if (sysNsSystem != null) {
                //菜单信息
                List<SysMenu> sysMenus = menuService.queryTree(sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = menuService.queryTree(sysNsSystem.getId(), 1, 1);
                //
                map.put("system", sysNsSystem);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysNsSystem> queryList() throws Exception {
        MPJLambdaWrapper<SysNsSystem> queryWrapper = buildSysNsSystemMPJLambdaWrapper();

        return this.list(queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryListNotInPermission(String permissonId) throws Exception {

        MPJLambdaWrapper<SysNsSystem> queryWrapper = buildSysNsSystemMPJLambdaWrapper();

        if(StrUtil.isNotBlank(permissonId)){
            LambdaQueryWrapper<SysPermissonSystem> queryWrapper2 =  Wrappers.lambdaQuery();
            queryWrapper2.eq(SysPermissonSystem::getPermissionid,permissonId);

            List<SysPermissonSystem> sysPermissonSystems = sysPermissionSystemMapper.selectList(queryWrapper2);
            if(sysPermissonSystems != null && sysPermissonSystems.size() > 0){
                List<String> systemIds = sysPermissonSystems.stream().map( item -> item.getSystemid()).collect(Collectors.toList());
                queryWrapper.notIn(SysNsSystem::getId,systemIds);
            }
        }

        return this.list(queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryListNotInRole(String roleId) throws Exception {

        MPJLambdaWrapper<SysNsSystem> queryWrapper = buildSysNsSystemMPJLambdaWrapper();
        if(StrUtil.isNotBlank(roleId)){
            LambdaQueryWrapper<SysRoleApplication> queryWrapper2 =  Wrappers.lambdaQuery();
            queryWrapper2.eq(SysRoleApplication::getRoleid,roleId);

            List<SysRoleApplication> sysRoleApplications = sysRoleApplicationMapper.selectList(queryWrapper2);
            if(sysRoleApplications != null && sysRoleApplications.size() > 0){
                List<String> systemIds = sysRoleApplications.stream().map( item -> item.getAppid()).collect(Collectors.toList());
                queryWrapper.notIn(SysNsSystem::getId,systemIds);
            }
        }

        return this.list(queryWrapper);
    }

    private MPJLambdaWrapper<SysNsSystem> buildSysNsSystemMPJLambdaWrapper() throws Exception {
        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() == RoleLevel.commonUser.getValue()){
            throw  new Exception("用户无访问权限");
        }

        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        MPJLambdaWrapper<SysNsSystem> queryWrapper =  MPJWrappers.lambdaJoin();
        if(isBizAdmin){
            queryWrapper.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysNsSystem::getId);
            queryWrapper.eq(SysUserApplication::getApptype, AppType.system.getValue());
            queryWrapper.eq(SysUserApplication::getUserid, userId);
        }
        queryWrapper.orderByDesc(SysNsSystem::getSort);
        return queryWrapper;
    }

    @Override
    public List<SysNsSystem> queryAll() {
        LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysNsSystem::getSort);
        List<SysNsSystem> list = this.list(wrapper);
        for (SysNsSystem sysNsSystem : list) {
            //0:菜单树 1:个人中心
            List<SysMenu> sysMenus = menuService.queryTree(sysNsSystem.getId(), 0, 0);
            List<SysMenu> userMenus = menuService.queryTree(sysNsSystem.getId(), 0, 1);
            sysNsSystem.setSysMenu(sysMenus);
            sysNsSystem.setUCenterMenu(userMenus);
        }
        return list;
    }

    @Override
    public void stateUp(String id, Integer state) {
        LambdaUpdateWrapper<SysNsSystem> update = Wrappers.lambdaUpdate();
        update.eq(SysNsSystem::getId, id)
                .set(SysNsSystem::getState, state);
        this.update(update);
    }

    @Override
    public HashMap<String, Object> querySystemInfoByUser(String userId, String key) {
        HashMap<String, Object> map = new HashMap<>();
        if (StringUtils.isNotEmpty(key)) {
            //查询系统信息
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysNsSystem::getKey, key)
                    .eq(SysNsSystem::getState, 1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = this.getOne(wrapper);
            if (sysNsSystem != null) {
                //菜单信息
                NsSystemStyle systemStyle = styleService.findOne(sysNsSystem.getStyleId());
                List<SysMenu> sysMenus = menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 1);
                //
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public HashMap<String, Object> querySystemBaseInfoByKey(String key) {
        HashMap<String, Object> map = new HashMap<>();
        if (StringUtils.isNotEmpty(key)) {
            //查询系统信息
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysNsSystem::getKey, key)
                    .eq(SysNsSystem::getState, 1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = this.getOne(wrapper);
            if (sysNsSystem != null) {
                //菜单信息
                NsSystemStyle systemStyle = styleService.findOne(sysNsSystem.getStyleId());
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
            } else {
                map = null;
            }
        }
        return map;
    }


    @Override
    public List<SysNsSystem> querySystemListByUser(String userId) {
        if(StrUtil.isBlank(userId)) {
            return null;
        }
        List<SysNsSystem> sysNsSystems = new ArrayList<>();
        //先查此用户下所有授权才中的应用id
        List<String> sysIds = menuMapper.queryUserMenuSystemId(userId);
        //再去查id匹配的所有应用
        if (sysIds.size() > 0) {
            LambdaQueryWrapper<SysNsSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.in(SysNsSystem::getId, sysIds)
                    .orderBy(true, true, SysNsSystem::getSort);
            sysNsSystems = systemMapper.selectList(wrapper);
        }

        //查找角色直接关联的系统
        MPJLambdaWrapper<SysNsSystem> joinWrapper = MPJWrappers.lambdaJoin();
        joinWrapper.leftJoin(SysRoleApplication.class,SysRoleApplication::getAppid,SysNsSystem::getId);
        joinWrapper.leftJoin(SysUserRole.class,SysUserRole::getRoleid,SysRoleApplication::getRoleid);
        joinWrapper.eq(SysUserRole::getUserid,userId);

        List<SysNsSystem> roleSystems = systemMapper.selectJoinList(SysNsSystem.class,joinWrapper);
        sysNsSystems.addAll(roleSystems);

        return sysNsSystems;
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(1);

        LambdaQueryWrapper<SysGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType,1);
        queryWrapper.eq(SysGroup::getName,group.getName());

        if(StrUtil.isBlank(group.getId())){
            int icount = sysGroupMapper.selectCount(queryWrapper);
            if(icount > 0){
                throw  new Exception("分组名称: 【"+ group.getName() +"】 已存在");
            }
            sysGroupMapper.insert(group);
        }else{
            queryWrapper.ne(SysGroup::getId,group.getId());
            int icount = sysGroupMapper.selectCount(queryWrapper);
            if(icount > 0){
                throw  new Exception("分组名称: 【"+ group.getName() +"】 已存在");
            }
            sysGroupMapper.updateById(group);
        }

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.updateUserApplication(userId,group.getId(),AppType.system.getValue(), AppNodeType.node.getValue());
        }
    }

    @Override
    public List<SysGroup> querySystemGroups(String userId) throws Exception {

        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() == RoleLevel.commonUser.getValue()){
            throw  new Exception("用户无访问权限");
        }

        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();

        MPJLambdaWrapper<SysGroup> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysGroup::getType,1);
        if(isBizAdmin){
            queryWrapper.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysGroup::getId);
            queryWrapper.eq(SysUserApplication::getApptype, AppType.system.getValue());
            queryWrapper.eq(SysUserApplication::getUserid, userId);
        }

        List<SysGroup> groups = sysGroupMapper.selectList(queryWrapper);
        List<String> groupIds = groups.stream().map(item -> item.getId()).collect(Collectors.toList());

        if(groupIds.size() > 0){
            MPJLambdaWrapper<SysNsSystem> queryWrapper2 =  MPJWrappers.lambdaJoin();
            queryWrapper2.in(SysNsSystem::getGroupId, groupIds);
            if(isBizAdmin){
                queryWrapper2.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysNsSystem::getId);
                queryWrapper2.eq(SysUserApplication::getApptype, AppType.system.getValue());
                queryWrapper2.eq(SysUserApplication::getUserid, userId);
            }

            List<SysNsSystem> systems = this.list(queryWrapper2);

            for(SysGroup group:groups){
                List<SysNsSystem> subSystem =  systems.stream().filter(item -> group.getId().equals(item.getGroupId())).collect(Collectors.toList());
                group.setSystems(subSystem);
            }
        }
        List<SysNsSystem> unGroupSystems = this.querySystemNoGroup(userId);
        if(unGroupSystems.size() > 0){
            SysGroup group = new SysGroup();
            group.setId("weifenzu");
            group.setName("未分组");
            group.setType(1);

            group.setSystems(unGroupSystems);
            groups.add(group);
        }

        return groups;
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        LambdaQueryWrapper<SysNsSystem> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNsSystem::getGroupId,groupId);
        int icount = this.count(queryWrapper);
        if(icount > 0){
            throw  new Exception("应用分组下有关联系统，不能删除");
        }
        sysGroupMapper.deleteById(groupId);

        String userId = this.getCurrentUserId();
        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null){
            throw  new Exception("用户无权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        if(isBizAdmin){
            sysUserApplicationService.deleteGroupIsNoChild(userId,groupId,AppType.system.getValue());
        }
    }

    @Override
    public List<SysNsSystem> querySystemNoGroup(String userId) throws Exception {

        SysUser user = sysUserMapper.selectById(userId);
        if(user == null || user.getCatalog() == null || user.getCatalog() == RoleLevel.commonUser.getValue()){
            throw  new Exception("用户无访问权限");
        }
        boolean isBizAdmin = user.getCatalog() == RoleLevel.bizAdmin.getValue();
        MPJLambdaWrapper<SysNsSystem> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.isNull(SysNsSystem::getGroupId);
        if(isBizAdmin){
            queryWrapper.leftJoin(SysUserApplication.class,SysUserApplication::getAppid,SysNsSystem::getId);
            queryWrapper.eq(SysUserApplication::getType, AppType.system.getValue());
        }

        return this.list(queryWrapper);
    }

    @Override
    public List<UserSysDTO> getUserSys() {
        List<String> types = Arrays.asList(ssoConfig.getLoginType().split(","));
        List<String> syncTypes = Arrays.asList(ssoConfig.getSyncType().split(","));
        //
        List<UserSysDTO> userSysDTOS = new ArrayList<>();
        for (UserSysEnum value : UserSysEnum.values()) {
            if (types.contains(value.value)) {
                UserSysDTO userSysDTO =
                    UserSysDTO.builder().value(value.value).name(value.name).type(value.type).sync(false).build();
                // 判断是否同步模式
                if (syncTypes.contains(value.value)) {
                    userSysDTO.setSync(true);
                }
                userSysDTOS.add(userSysDTO);
            }
        }
        return userSysDTOS;
    }


    private String getCurrentUserId(){
        HttpServletRequest request = HttpServletUtil.getRequest();

        return  auth2Service.queryCurrentUserId(request);
    }

}
