package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.NsSystemStyle;
import com.geoway.design.biz.mapper.NsSystemStyleMapper;
import com.geoway.design.biz.service.sys.INsSystemStyleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 主题
 * @author: wujing
 * @Date: 2021/11/15
 */
@Service
public class NsSystemStyleServiceImpl extends ServiceImpl<NsSystemStyleMapper, NsSystemStyle>
    implements INsSystemStyleService {

    @Autowired
    private NsSystemStyleMapper systemStyleMapper;

    @Override
    public void saveOrUp(NsSystemStyle nsSystemStyle) throws Exception {
        if(StrUtil.isBlank(nsSystemStyle.getKey())){
            throw new Exception("关键字不能为空！");
        }else {
            LambdaQueryWrapper<NsSystemStyle> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(NsSystemStyle::getKey,nsSystemStyle.getKey());
            if(StrUtil.isNotBlank(nsSystemStyle.getId())){
                wrapper.ne(NsSystemStyle::getId,nsSystemStyle.getId());
            }
            Integer one = this.count(wrapper);
            if(one>0){
                throw new Exception("关键字【"+nsSystemStyle.getKey()+"】已存在！");
            }
        }
        if(StrUtil.isBlank(nsSystemStyle.getName())){
            throw new Exception("主题名称不能为空！");
        }

        if(StrUtil.isNotBlank(nsSystemStyle.getId())){
            NsSystemStyle oldStyle = this.getById(nsSystemStyle.getId());
            nsSystemStyle.setSort(oldStyle.getSort());
//            if(StrUtil.isBlank(nsSystemStyle.getBg())){
//                nsSystemStyle.setBg(oldStyle.getBg());
//            }
//
//            if(StrUtil.isBlank(nsSystemStyle.getSnapshot())){
//                nsSystemStyle.setSnapshot(oldStyle.getSnapshot());
//            }
        }else{
            int iSort = systemStyleMapper.selectCount(null) + 1;
            nsSystemStyle.setSort(iSort);
        }

        this.saveOrUpdate(nsSystemStyle);
    }

    @Override
    public NsSystemStyle findOne(String key) {
        LambdaQueryWrapper<NsSystemStyle> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(NsSystemStyle::getKey, key);
        wrapper.last("LIMIT 1");

        NsSystemStyle one = this.getOne(wrapper);

        return one;
    }

    @Override
    public void delete(String ids) {
        String[] idArr = ids.split(",");
        this.removeByIds(Arrays.asList(idArr));
    }

    @Override
    public List<NsSystemStyle> queryList(String filterParam) throws Exception {

        MyBatisQueryMapperUtils<NsSystemStyle> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, NsSystemStyle.class);
        queryWrapper.orderByDesc("f_id");
        List<NsSystemStyle>  styles = this.list(queryWrapper);

        return styles;
    }


}
