package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.SysAppBuildDTO;
import com.geoway.design.biz.mapper.SysAppBuildMapper;
import com.geoway.design.biz.service.sys.SysAppBuildService;
import generator.entity.SysAppBuild;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
* @author wangqiang
* @description 针对表【sys_app_build】的数据库操作Service实现
* @createDate 2024-10-22 14:30:51
*/
@Service
public class SysAppBuildServiceImpl extends ServiceImpl<SysAppBuildMapper, SysAppBuild>
    implements SysAppBuildService{

    @Override
    public void saveOrUp(SysAppBuildDTO sysAppBuildDTO) {
        SysAppBuild entity;
        if(StrUtil.isBlank(sysAppBuildDTO.getId())){
            entity = new SysAppBuild();
            entity.setCreatetime(new Date());
        }else {
            entity = this.getById(sysAppBuildDTO.getId());
        }
        BeanUtil.copyProperties(sysAppBuildDTO,entity,true);
        this.saveOrUpdate(entity);
    }

    @Override
    public IPage<SysAppBuild> queryPage(String filterParam, int page, int size,String userId,Integer catalog) throws Exception {
        Page<SysAppBuild> pages = new Page<>(page, size);

        if(catalog==3) return pages;
        if(catalog==2){
            filterParam+=";appUserId_EQ_"+userId;
        }
        MyBatisQueryMapperUtils<SysAppBuild> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysAppBuild.class);
        queryWrapper.orderByDesc("f_createtime");

        return this.baseMapper.selectPage(pages, queryWrapper);
    }

    @Override
    public void audit(String userId, String id, Boolean passed, String auditOpinion) {
        SysAppBuild entity = this.getById(id);
        if (entity == null) return;
        entity.setAuditState(Boolean.TRUE.equals(passed) ? "1" : "2");
        entity.setAuditOpinion(auditOpinion);
        entity.setAuditTime(new Date());
        entity.setAuditUser(userId);
        this.updateById(entity);
    }
}




