package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysApplicationGroup;
import com.geoway.design.biz.mapper.SysApplicationGroupMapper;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author daidongdong
 * @description 针对表【sys_application_group】的数据库操作Service实现
 * @createDate 2022-12-14 16:52:28
 */
@Service
public class SysApplicationGroupServiceImpl extends ServiceImpl<SysApplicationGroupMapper, SysApplicationGroup>
        implements SysApplicationGroupService {

    @Override
    public void saveApplicationGroup(String appId, String groupId) {

        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid,appId);
        queryWrapper.eq(SysApplicationGroup::getGroupid,groupId);

        int iCount = this.count(queryWrapper);
        if(iCount == 0){
            SysApplicationGroup applicationGroup = new SysApplicationGroup();
            applicationGroup.setAppid(appId);
            applicationGroup.setGroupid(groupId);
            this.saveOrUpdate(applicationGroup);
        }
    }

    @Override
    public void removeApplicationInGroup(String appId) {
        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid,appId);

        this.remove(queryWrapper);
    }

    @Override
    public void removeApplicationGroup(String appId, String groupId) {

        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid,appId);
        queryWrapper.eq(SysApplicationGroup::getGroupid,groupId);

        this.remove(queryWrapper);
    }

    @Override
    public List<String> queryGroupAppIds(String groupId) {
        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getGroupid,groupId);

        List<SysApplicationGroup> sysAppGroups = this.list(queryWrapper);

        List<String> appIds = sysAppGroups.stream().map( i -> i.getAppid()).collect(Collectors.toList());
        return appIds;
    }

    @Override
    public int queryCount(String groupId){
        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getGroupid,groupId);

        int count = this.count(queryWrapper);
        return count;
    }

    @Override
    public List<String> queryAppGroupIds(List<String> appIds) {

        LambdaQueryWrapper<SysApplicationGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(SysApplicationGroup::getAppid, appIds);

        List<SysApplicationGroup> appGroups = this.list(queryWrapper);
        List<String> groupIds = appGroups.stream().map( item -> item.getGroupid()).collect(Collectors.toList());


        return groupIds;
    }
}