package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysFunctionServerRoutes;
import com.geoway.design.biz.mapper.SysFunctionServerRoutesMapper;
import com.geoway.design.biz.service.sys.SysFunctionServerRoutesService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_function_server_routes】的数据库操作Service实现
* @createDate 2025-02-27 15:48:23
*/
@Service
public class SysFunctionServerRoutesServiceImpl extends ServiceImpl<SysFunctionServerRoutesMapper, SysFunctionServerRoutes>
    implements SysFunctionServerRoutesService{

    @Override
    public List<SysFunctionServerRoutes> queryListByFunctionId(String fuctionId) {
        LambdaQueryWrapper<SysFunctionServerRoutes> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysFunctionServerRoutes::getFunctionid,fuctionId);
        queryWrapper.orderByAsc(SysFunctionServerRoutes::getId);

        return this.list(queryWrapper);
    }
}




