package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.ExcelUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.entity.SysOplogBackup;
import com.geoway.design.biz.service.sys.SysOplogBackupService;
import com.geoway.design.biz.mapper.SysOplogBackupMapper;
import com.geoway.design.biz.service.sys.SysOplogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

/**
* @author wangqiang
* @description 针对表【sys_oplog_backup】的数据库操作Service实现
* @createDate 2025-06-10 16:39:55
*/
@Slf4j
@Service
public class SysOplogBackupServiceImpl extends ServiceImpl<SysOplogBackupMapper, SysOplogBackup>
    implements SysOplogBackupService{

    @Autowired
    private SysOplogService sysOplogService;

    /**
     * 从输入的开始日期备份到昨天（包括）
     * @param startDate
     * @throws Exception
     */
    @Override
    public void backup(String startDate) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate inputDate = LocalDate.parse(startDate, formatter);
        LocalDate currentDate = LocalDate.now().minusDays(1);
        long daysBetween = ChronoUnit.DAYS.between(inputDate, currentDate);
        if(daysBetween<0){
            throw new RuntimeException("只能备份昨天及之前的日志！");
        }

        // 备份时间限制
        if (daysBetween > 365) {
            inputDate = currentDate.minusYears(1);
        }

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (!inputDate.isAfter(currentDate)) {
            String dateStr = inputDate.format(formatter);

            SysOplogBackup sysOplogBackup = this.getOne(Wrappers.lambdaQuery(SysOplogBackup.class)
                    .eq(SysOplogBackup::getDate, inputDate));

            // 循环备份
            inputDate = inputDate.plusDays(1);

            if(sysOplogBackup!=null) continue;

            sysOplogBackup =SysOplogBackup.builder().name(dateStr).date(simpleDateFormat.parse(dateStr)).build();

            try {
                String[] dateStrArr = dateStr.split("-");
                String folder = "data/logBackup/" + dateStrArr[0] + dateStrArr[1];
                Path folderPath = Paths.get(folder);
                if (!Files.exists(folderPath)) {
                    Files.createDirectories(folderPath);
                }

                String oplogFilter = String.format("Q_createtime_S_GE=%s 00:00:00;Q_createtime_S_LE=%s 23:59:59", dateStr, dateStr);
                List<SysOplog> logs = sysOplogService.findByFilterParam(oplogFilter);

                String filePath = folder + File.separator + dateStr + ".xlsx";
                ExcelUtil.exportExcel(logs, null, "sheet1", SysOplog.class, dateStr, true, filePath);

                sysOplogBackup.setPath(filePath);
            } catch (Exception ex) {
                log.error("备份日志出错",ex);
            }
            this.save(sysOplogBackup);
        }
    }

    @Override
    public IPage<SysOplogBackup> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils<SysOplogBackup> qum = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qum.queryMapper(filterParam, SysOplogBackup.class);

        queryWrapper.orderByDesc("f_createtime");
        Page<SysOplogBackup> pages = new Page<>(page, size);

        return this.page(pages, queryWrapper);
    }
}




