package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysPermissionSubfunction;
import com.geoway.design.biz.entity.SysSubFunction;
import com.geoway.design.biz.entity.SysSubFunctionGroup;
import com.geoway.design.biz.mapper.SysPermissionSubfunctionMapper;
import com.geoway.design.biz.service.sys.ISysPermissionSubfunctionService;
import com.geoway.design.biz.service.sys.ISysSubFuncitonGroupService;
import com.geoway.design.biz.service.sys.ISysSubFunctionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 */
@Service
public class SysPermissionSubfunctionServiceImpl extends ServiceImpl<SysPermissionSubfunctionMapper, SysPermissionSubfunction>
    implements ISysPermissionSubfunctionService {
    @Autowired
    private ISysSubFunctionService sysSubFunctionService;
    @Autowired
    private ISysSubFuncitonGroupService sysSubFuncitonGroupService;
    @Override
    public void batchSave(String permissionId, String menuId, List<String> funIds) {
        //先删除后增加
        LambdaQueryWrapper<SysPermissionSubfunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionSubfunction::getPermissionid, permissionId).eq(SysPermissionSubfunction::getMenuid,menuId);
        this.remove(wrapper);
        List<SysPermissionSubfunction> funs=new ArrayList<>();
        funIds.forEach(f->{
            SysPermissionSubfunction fun=new SysPermissionSubfunction();
            fun.setPermissionid(permissionId);
            fun.setMenuid(menuId);
            fun.setFunid(f);
            funs.add(fun);
        });
        this.saveBatch(funs);
    }

    @Override
    public List<SysSubFunctionGroup> queryByPermissionId(String permissionId, String menuId) {
        LambdaQueryWrapper<SysPermissionSubfunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionSubfunction::getPermissionid, permissionId).eq(SysPermissionSubfunction::getMenuid,menuId);
        List<SysPermissionSubfunction> permissionSubfunctions= this.list(wrapper);
        if(permissionSubfunctions==null||permissionSubfunctions.size()==0){
            return new ArrayList<>();
        }
        List<String> ids=permissionSubfunctions.stream().map(f->f.getFunid()).collect(Collectors.toList());
        return sysSubFuncitonGroupService.listBySubFunctionIds(ids);
    }

    @Override
    public List<SysSubFunction> querySubFunctionByPermissionIdList(List<String> permissionIds, String menuId) {
        if(permissionIds == null || permissionIds.size() == 0){
            return  new ArrayList<SysSubFunction>();
        }

        LambdaQueryWrapper<SysPermissionSubfunction> wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysPermissionSubfunction::getPermissionid, permissionIds);
        wrapper.eq(SysPermissionSubfunction::getMenuid,menuId);

        List<SysPermissionSubfunction> permissionSubfunctions= this.list(wrapper);
        if(permissionSubfunctions==null||permissionSubfunctions.size()==0){
            return new ArrayList<>();
        }
        List<String> ids=permissionSubfunctions.stream().map(f->f.getFunid()).collect(Collectors.toList());
        //去重
        ids = ids.stream().distinct().collect(Collectors.toList());

        return sysSubFunctionService.listSubFunctionByIds(ids);
    }


}




