package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysPermissionMenu;
import com.geoway.design.biz.entity.SysPermissonSystem;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionSystemMapper;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.ISysPermissionSystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 */
@Service
public class SysPermissionSystemServiceImpl extends ServiceImpl<SysPermissionSystemMapper, SysPermissonSystem>
    implements ISysPermissionSystemService {

    @Autowired
    INsSystemService systemService;
    @Autowired
    SysMenuMapper sysMenuMapper;
    @Autowired
    SysPermissionMenuMapper sysPermissionMenuMapper;

    @Override
    public List<SysNsSystem> queryByPermissionId(String permissionId) {
        LambdaQueryWrapper<SysPermissonSystem> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonSystem::getPermissionid, permissionId);
        List<SysPermissonSystem> roleSystems=this.list(wrapper);
        List<String> systemIds= roleSystems.stream().map(f->f.getSystemid()).collect(Collectors.toList());
        if(systemIds.size()==0){
            return new ArrayList<>();
        }
        return systemService.listByIds(systemIds);
    }

    @Override
    public void delete(String permissionId, String systemId) {


        //查询系统关联的菜单信息并删除与权限的绑定
        LambdaQueryWrapper<SysMenu> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysMenu::getSystemId,systemId);
        List<SysMenu> sysMenus = sysMenuMapper.selectList(queryWrapper2);
        List<String> menuIds = sysMenus.stream().map( i -> i.getId()).collect(Collectors.toList());

        //删除权限系统关联的菜单信息
        if(menuIds.size()>0){
            LambdaQueryWrapper<SysPermissionMenu> queryWrapper3 = Wrappers.lambdaQuery();
            queryWrapper3.eq(SysPermissionMenu::getPermissionid,permissionId);
            queryWrapper3.in(SysPermissionMenu::getMenuid,menuIds);
            sysPermissionMenuMapper.delete(queryWrapper3);
        }

        LambdaQueryWrapper<SysPermissonSystem> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonSystem::getPermissionid, permissionId).eq(SysPermissonSystem::getSystemid,systemId);
        this.remove(wrapper);
    }

    @Override
    public void batchDelete(String permissionId, List<String> systemIds) {
        for(String systemId:systemIds){
            this.delete(permissionId,systemId);
        }
    }

    @Override
    public void batchSave(String permissionId, List<String> systemIds,boolean isClear) {
        //先删除后增加
        if(isClear){
            LambdaQueryWrapper<SysPermissonSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysPermissonSystem::getPermissionid, permissionId);
            this.remove(wrapper);
        }

        List<SysPermissonSystem> systems=new ArrayList<>();
        systemIds.forEach(f->{
            SysPermissonSystem sys=new SysPermissonSystem();
            sys.setPermissionid(permissionId);
            sys.setSystemid(f);
            systems.add(sys);
        });
        this.saveBatch(systems);
    }
}




