package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.dto.RoleAppsDTO;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysRoleApplication;
import com.geoway.design.biz.mapper.ApplicationSysMapper;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.mapper.SysRoleApplicationMapper;
import com.geoway.design.biz.service.sys.SysRoleApplicationService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_application(角色应用权限表)】的数据库操作Service实现
* @createDate 2024-10-15 17:25:14
*/
@Service
@Transactional
public class SysRoleApplicationServiceImpl extends ServiceImpl<SysRoleApplicationMapper, SysRoleApplication>
    implements SysRoleApplicationService{

    @Autowired
    ApplicationSysMapper applicationSysMapper;

    @Autowired
    NsSystemMapper nsSystemMapper;

    @Override
    public void saveRoleApplications(String roleId, List<String> appIds, int appType,boolean isClear) {
        if(appIds == null || appIds.size() == 0 ){
            return;
        }
        //先删除后增加
        if(isClear){
            LambdaQueryWrapper<SysRoleApplication> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, roleId);
            wrapper.eq(SysRoleApplication::getApptype,appType);
            this.remove(wrapper);
        }
        List<SysRoleApplication> roleApps=new ArrayList<>();
        appIds.forEach(appId->{
            SysRoleApplication roleApp = new SysRoleApplication();
            roleApp.setAppid(appId);
            roleApp.setRoleid(roleId);
            roleApp.setApptype(appType);

            roleApps.add(roleApp);
        });
        this.saveBatch(roleApps);
    }

    @Override
    public void saveRoleAppsAndSysems(String roleId, List<String> appIds, List<String> systemIds,boolean isClear) {

        this.saveRoleApplications(roleId,appIds,AppType.application.getValue(),isClear);
        this.saveRoleApplications(roleId,systemIds,AppType.system.getValue(),isClear);
    }

    @Override
    public List<SysApplication> queryRoleApplications(String roleId) {

        MPJLambdaWrapper<SysApplication> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleApplication.class,SysRoleApplication::getAppid, SysApplication::getId);
        queryWrapper.eq(SysRoleApplication::getApptype, AppType.application.getValue());
        queryWrapper.eq(SysRoleApplication::getRoleid,roleId);

        return applicationSysMapper.selectJoinList(SysApplication.class,queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryRoleSystems(String roleId) {
        MPJLambdaWrapper<SysNsSystem> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleApplication.class,SysRoleApplication::getAppid, SysNsSystem::getId);
        queryWrapper.eq(SysRoleApplication::getApptype, AppType.system.getValue());
        queryWrapper.eq(SysRoleApplication::getRoleid,roleId);

        return nsSystemMapper.selectJoinList(SysNsSystem.class,queryWrapper);
    }

    @Override
    public RoleAppsDTO queryRoleAppsAndSystems(String roleId) {

        List<SysApplication> apps = this.queryRoleApplications(roleId);
        List<SysNsSystem> systems = this.queryRoleSystems(roleId);

        RoleAppsDTO roleAppsDTO = new RoleAppsDTO();
        roleAppsDTO.setRoleId(roleId);
        roleAppsDTO.setApps(apps);
        roleAppsDTO.setSystems(systems);

        return roleAppsDTO;
    }

    @Override
    public void removeRoleAppsAndSysems(String roleId, List<String> appIds, List<String> systemIds) {

        if(appIds != null && appIds.size() > 0){
            LambdaQueryWrapper<SysRoleApplication> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, roleId);
            wrapper.eq(SysRoleApplication::getApptype,AppType.application.getValue());
            wrapper.in(SysRoleApplication::getAppid,appIds);
            this.remove(wrapper);
        }

        if(systemIds != null && systemIds.size() > 0){
            LambdaQueryWrapper<SysRoleApplication> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, roleId);
            wrapper.eq(SysRoleApplication::getApptype,AppType.system.getValue());
            wrapper.in(SysRoleApplication::getAppid,systemIds);
            this.remove(wrapper);
        }
    }
}




