package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysRoleMenu;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysRoleMenuMapper;
import com.geoway.design.biz.service.sys.SysRoleMenuService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_menu(角色关联菜单表)】的数据库操作Service实现
* @createDate 2024-10-15 17:25:14
*/
@Service
public class SysRoleMenuServiceImpl extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
    implements SysRoleMenuService{

    @Autowired
    SysMenuMapper sysMenuMapper;

    @Autowired
    FunctionSysMapper functionSysMapper;

    @Override
    public List<SysMenu> queryRelateMenus(String roleId, String appId) {

        MPJLambdaWrapper<SysMenu> wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class,SysRoleMenu::getMenuid, SysMenu::getId);
        wrapper.eq(SysRoleMenu::getRoleid,roleId);
        wrapper.eq(SysRoleMenu::getAppid,appId);
        wrapper.eq(SysRoleMenu::getApptype, AppType.system.getValue());

        return sysMenuMapper.selectJoinList(SysMenu.class,wrapper);
    }

    @Override
    public List<SysFunction> queryRelateFunctions(String roleId, String appId) {
        MPJLambdaWrapper<SysFunction> wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class,SysRoleMenu::getMenuid, SysFunction::getId);
        wrapper.eq(SysRoleMenu::getRoleid,roleId);
        wrapper.eq(SysRoleMenu::getAppid,appId);
        wrapper.eq(SysRoleMenu::getApptype, AppType.application.getValue());

        return functionSysMapper.selectJoinList(SysFunction.class,wrapper);

    }

    @Override
    public void saveRoleMenus(String roleId, String appId, int appType, List<String> menuIds) {

        //先删除
        LambdaQueryWrapper<SysRoleMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRoleMenu::getRoleid,roleId);
        wrapper.eq(SysRoleMenu::getAppid,appId);
        wrapper.eq(SysRoleMenu::getApptype,appType);

        this.remove(wrapper);

        //保存菜单信息
        if(menuIds.size() > 0){
            List<SysRoleMenu> roleMenus = new ArrayList<>();
            for(String menuId: menuIds){
                SysRoleMenu roleMenu = new SysRoleMenu();
                roleMenu.setMenuid(menuId);
                roleMenu.setAppid(appId);
                roleMenu.setApptype(appType);
                roleMenu.setRoleid(roleId);

                roleMenus.add(roleMenu);
            }
            this.saveBatch(roleMenus);
        }

    }
}




