package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysSubFunction;
import com.geoway.design.biz.mapper.SysSubFunctionMapper;
import com.geoway.design.biz.service.sys.ISysSubFunctionService;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 *
 */
@Service
public class SysSubFunctionServiceImpl extends ServiceImpl<SysSubFunctionMapper, SysSubFunction>
    implements ISysSubFunctionService {

    @Override
    public void saveOrUp(SysSubFunction privilege) throws Exception {
        //判断名称是否重复
        LambdaQueryWrapper<SysSubFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getName, privilege.getName());
        wrapper.eq(SysSubFunction::getGroupid, privilege.getGroupid());
        //有id就是更新
        if(StrUtil.isNotBlank(privilege.getId())) {
            wrapper.ne(SysSubFunction::getId, privilege.getId());
            privilege.setUpdatetime(new Date());
        }
        else{
            privilege.setSort(getNextOrder(privilege.getId()));
            privilege.setUpdatetime(new Date());
            privilege.setCreatetime(new Date());
        }
        int iCount = this.count(wrapper);
        if(iCount > 0){
            throw new Exception("权限名称: "+ privilege.getName()+"  已存在！");
        }
        this.saveOrUpdate(privilege);
    }

    @Override
    public List<SysSubFunction> listSubFunctionByIds(List<String> subFunctionIds) {
        List<SysSubFunction>  subFunctions=this.listByIds(subFunctionIds);
        return subFunctions;
    }

    private int getNextOrder(String groupId) {
        SysSubFunction group=this.getOne(new LambdaQueryWrapper<SysSubFunction>().eq(SysSubFunction::getGroupid,groupId).orderByDesc(SysSubFunction::getSort).last("limit 1"));
        if(group==null){
            return 1;
        }else{
            return group.getSort()+1;
        }
    }
}




