package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysUserApplication;
import com.geoway.design.biz.mapper.SysUserApplicationMapper;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_application(应用关联的用户，只针对二级管理员)】的数据库操作Service实现
* @createDate 2024-10-15 17:22:57
*/
@Service
public class SysUserApplicationServiceImpl extends ServiceImpl<SysUserApplicationMapper, SysUserApplication>
    implements SysUserApplicationService{

    @Autowired
    SysApplicationGroupService sysApplicationGroupService;

    @Override
    public void updateUserApplication(String userId, String appId, int appType,int nodeType) {

        LambdaQueryWrapper<SysUserApplication>  queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, userId);
        queryWrapper.eq(SysUserApplication::getAppid, appId);
        queryWrapper.eq(SysUserApplication::getApptype, appType);

       int icount = this.count(queryWrapper);
       if(icount == 0){
           SysUserApplication sysUserApplication = new SysUserApplication();
           sysUserApplication.setUserid(userId);
           sysUserApplication.setAppid(appId);
           sysUserApplication.setApptype(appType);
           sysUserApplication.setType(nodeType);

           this.save(sysUserApplication);
       }

    }

    @Override
    public void deleteExistApplication(String userId, String appId, int appType) {
        LambdaQueryWrapper<SysUserApplication>  queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, userId);
        queryWrapper.eq(SysUserApplication::getAppid, appId);
        queryWrapper.eq(SysUserApplication::getApptype, appType);

        this.remove(queryWrapper);
    }

    @Override
    public void deleteGroupIsNoChild(String userId, String groupId, int appType) {

       List<String> subAppIds =  sysApplicationGroupService.queryGroupAppIds(groupId);

        LambdaQueryWrapper<SysUserApplication>  queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, userId);
        queryWrapper.in(SysUserApplication::getAppid, subAppIds);
        queryWrapper.eq(SysUserApplication::getApptype, appType);

        int icount = this.count(queryWrapper);
        if(icount == 0){
           this.deleteExistApplication(userId,groupId,appType);
        }

    }
}




