package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysUserRegion;
import com.geoway.design.biz.mapper.SysUserRegionMapper;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_region】的数据库操作Service实现
* @createDate 2022-01-20 15:44:01
*/
@Service
public class SysUserRegionServiceImpl extends ServiceImpl<SysUserRegionMapper, SysUserRegion>
    implements ISysUserRegionService {

    @Override
    @OpLog(name = "修改用户所属辖区", opType = OpLog.OpType.update)
    public void updateUserRegions(String userId, List<String> regions) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRegion::getUserid,userId);

        //先移除
        this.remove(wrapper);
        if(regions == null){
            return;
        }
        List<SysUserRegion> userRegions = new ArrayList<>();
        for(String regioncode: regions){
            SysUserRegion userRegion = new SysUserRegion();
            userRegion.setUserid(userId);
            userRegion.setRegioncode(regioncode);

            userRegions.add(userRegion);
        }
        if(userRegions.size() > 0){
            this.saveBatch(userRegions);
        }
    }
}




