package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRegister;
import com.geoway.design.biz.mapper.SysUserRegisterMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.sys.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangqiang
 * @description 针对表【sys_user_register】的数据库操作Service实现
 * @createDate 2024-07-03 16:40:13
 */
@Service
public class SysUserRegisterServiceImpl extends ServiceImpl<SysUserRegisterMapper, SysUserRegister>
        implements ISysUserRegisterService {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    IOrganizationService organizationService;
    @Autowired
    BizManagerRangeService bizManagerRangeService;
    @Autowired
    ISysRegionService sysRegionService;
    @Autowired
    ISysUserRoleService sysUserRoleService;

    @Value("${userTel.encrypt:true}")
    private boolean userTelEncrypt;
    @Value("${userRegister.auditMode:2}")
    private int auditMode;


    @Override
    public Boolean checkAccoutRepeat(String accout) throws Exception {
        List<SysUser> users = sysUserService.queryList("accout_EQ_" + accout);
        // auditState=2 审核不通过可以继续注册
        List<SysUserRegister> usersRegister = this.queryList("accout_EQ_" + accout + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean checkTelRepeat(String tel) throws Exception {
        if (userTelEncrypt) {
            String telEncrypt = AESUtils.encrypt(tel, AESUtils.KEY);
            List<SysUser> users = sysUserService.queryList("telEncrypt_EQ_" + telEncrypt);
            List<SysUserRegister> usersRegister = this.queryList("telEncrypt_EQ_" + telEncrypt + ";auditState_NE_2");
            return users.size() > 0 || usersRegister.size() > 0;
        } else {
            List<SysUser> users = sysUserService.queryList("tel_EQ_" + tel);
            List<SysUserRegister> usersRegister = this.queryList("tel_EQ_" + tel + ";auditState_NE_2");
            return users.size() > 0 || usersRegister.size() > 0;
        }
    }

    @Override
    public Boolean registerUser(SysUserRegister sysUserRegister) {
        String tel = sysUserRegister.getTel();
        if (StringUtils.isBlank(tel)) {
            throw new ServiceException("手机号不能为空");
        }
        if (tel.length() != 11) {
            throw new RuntimeException("手机号格式错误");
        }
        // 手机号加密
        try {
            sysUserRegister.setTelEncrypt(AESUtils.encrypt(tel, AESUtils.KEY));
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 手机号隐藏中间4位
        sysUserRegister.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));

        this.save(sysUserRegister);

        return true;
    }

    @Override
    public IPage<SysUserRegister> queryPage(String filterParam, int page, int size, String userid, Integer userCatalog) throws Exception {
        Page<SysUserRegister> pages = new Page<>(page, size);

        if (userCatalog == null || userCatalog == 3) return pages;
        if (userCatalog == 2) {
            // 业务管理员查询其管辖组织、辖区下注册的用户
            String orgFilter = "";
            List<String> manageOrgs = bizManagerRangeService.queryAllManageOrgs(userid);
            if (manageOrgs.size() > 0) {
                orgFilter = "QOR_organization_S_IN=" + StrUtil.join(",", manageOrgs) + ";";
            }
            String regionFilter = "";
            List<String> manageRegions = bizManagerRangeService.queryAllManageRegions(userid);
            if (manageRegions.size() > 0) {
                regionFilter = "QOR_region_S_IN=" + StrUtil.join(",", manageRegions) + ";";
            }

            if (manageOrgs.size() == 0 && manageRegions.size() == 0) return pages;

            String filter = String.format(";(%s);", auditMode == 1 ? regionFilter : auditMode == 2 ? orgFilter : orgFilter + regionFilter);
            filterParam = filter + filterParam;
        }
        MyBatisQueryMapperUtils<SysUserRegister> qmu = new MyBatisQueryMapperUtils<>();

        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc("f_createtime");

        IPage<SysUserRegister> pageUsers = this.baseMapper.selectPage(pages, queryWrapper);
        for (SysUserRegister register : pageUsers.getRecords()) {
            // 查找辖区全路径
            if (StringUtils.isNotBlank(register.getOrganization())) {
                List<SysOrganization> organizations = organizationService.queryList("id_IN_" + register.getOrganization());
                register.setOrgNames(StringUtils.join(organizations.stream().map(SysOrganization::getAllname).collect(Collectors.toList()), ","));
            }

            // 查找辖区全路径
            if (StringUtils.isNotBlank(register.getRegion())) {
                List<SysRegion> regions = sysRegionService.queryList("regionCode_IN_" + register.getRegion(), null);
                regions.forEach(m -> {
                    m.setAllname(StrUtil.join("/", sysRegionService.queryAllParentRegion(m.getRegionCode())
                            .stream().map(SysRegion::getName).collect(Collectors.toList())));
                });
                register.setRegionNames(StringUtils.join(regions.stream().map(SysRegion::getAllname).collect(Collectors.toList()), ","));
            }

            if (StringUtils.isNotBlank(register.getAuditUser())) {
                register.setAuditUserName(sysUserService.queryOne(register.getAuditUser()).getName());
            }
        }

        return pageUsers;
    }

    @Override
    public List<SysUserRegister> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils<SysUserRegister> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc("f_createtime");

        List<SysUserRegister> users = this.baseMapper.selectList(queryWrapper);
        return users;
    }

    @Override
    public Boolean audit(String userId, String id, Boolean passed, String auditOpinion, String roleIds) throws Exception {
        if (StringUtils.isBlank(userId)) return false;
        SysUserRegister entity = this.getById(id);
        if (entity == null) return false;
        entity.setAuditState(Boolean.TRUE.equals(passed) ? "1" : "2");
        entity.setAuditOpinion(auditOpinion);
        entity.setAuditTime(new Date());
        entity.setAuditUser(userId);
        this.updateById(entity);

        // 审核通过时添加到用户表
        if ("1".equals(entity.getAuditState())) {
            SysUser sysUser = new SysUser();
            BeanUtil.copyProperties(entity, sysUser, true);
            sysUser.setId(null);
            sysUser.setCatalog(3); // 普通用户

            if (entity.getKind() == 1) {
                UserRelParams userRelParams = new UserRelParams();
                if (StrUtil.isNotBlank(entity.getOrganization())) {
                    userRelParams.setOrganizations(Arrays.asList(entity.getOrganization().split(",")));
                }
                userRelParams.setRegions(Arrays.asList(entity.getRegion()));
                sysUser.setOtherParams(JSON.toJSONString(userRelParams));
            }

            sysUserService.saveOrUp(sysUser, null, false);

            // 保存用户角色
            if (StrUtil.isNotBlank(roleIds)) {
                sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(roleIds.split(",")));
            }
        }

        return true;
    }
}




