package com.geoway.design.biz.service.uis;

import com.geoway.design.biz.dto.uis.SimpleUserDTO;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;

import java.util.List;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName IUISService
 * @Description 仿UIS1.0用户信息查询
 * @date 2024/3/12 15:37
 * @Version 1.0
 */
public interface IUISService {
    List<SimpleUserDTO> getUserInfo(Map<String, String> map);
    void modifyUserInfo(Map<String, String> map);
    List<SimpleUserDTO> getUserList(String filterParam);
    List<SysOrganization> getOrgTree(Map<String, String> paramMap);
    List<SysOrganization> getOrgInfo(Map<String, String> paramMap);
    List<SysRole> queryRoleTree(String filterParam);
    List<SysPermission> queryRolePermissions(Map<String, String> paramMap);
    List<SysRole> queryRoleList(String filterParam);
    List<SysUser> queryRoleUsers(String roleId);
}
