package com.geoway.design.biz.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.spring.SpringUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.service.dev.impl.LocalUserServiceImpl;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName GuestUtil
 * @Description TODO
 * @date 2025/7/29 11:44
 * @Version 1.0
 */
public class GuestUtil {


    public static String getGuestToken(){

        String token="Geoway";
        try {
            String formattedDate = DateUtil.format(new Date(), DatePattern.NORM_DATE_PATTERN);
            String encryptedPart = AESUtils.encrypt(formattedDate, AESUtils.KEY);
            token=token+encryptedPart;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
        return token;
    }
    /**
     * 校验游客token
     * @param token
     * @return
     */
    public static boolean validateGuestToken(String token) {
        if(StrUtil.isBlank(token)){
            return false;
        }
        String tokenPrefix="Geoway";
        if (!token.startsWith(tokenPrefix)) {
            return false;
        }
        // 提取加密部分
        String encryptedPart = token.substring(tokenPrefix.length());
        try {
            // AES解密
            String decryptedStr = AESUtils.decrypt(encryptedPart,AESUtils.KEY);
            String formattedDate = DateUtil.format(new Date(), DatePattern.NORM_DATE_PATTERN);
            // 验证是否为日期格式(简单版)
            return formattedDate.equalsIgnoreCase(decryptedStr);
        } catch (Exception e) {
            return false;
        }
    }

    public static RpcAccessToken getGuestRpcAccessToken(String token){
        LocalUserServiceImpl localUserService= SpringUtils.getBean(LocalUserServiceImpl.class);
        SysUser sysUser = localUserService.query("guest");
        List<SysRegion> regions = sysUser.getRegions();
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        SsoUser ssoUser=new SsoUser();
        ssoUser.setId(sysUser.getId());
        ssoUser.setUserid(sysUser.getId());
        ssoUser.setUserName(sysUser.getAname());
        ssoUser.setLoginName(sysUser.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(sysUser.getCatalog());
        ssoUser.setSource(sysUser.getSource());
        ssoUser.setToken(token);
        ssoUser.setUserCatalog(3);
        RpcAccessToken rpcAccessToken = new RpcAccessToken(ssoUser.getToken(), 60,ssoUser.getToken(), ssoUser);
        return rpcAccessToken;
    }


}
