/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.aspect;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.design.base.support.RedisUtil;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.SysOplogService;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Service
public class OpLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OpLogAspect.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SysOplogService sysOplogService;
    @Autowired
    IOauth2Service oauth2Service;
    @Value(value="${sso.app.id}")
    private String appId;

    @Pointcut(value="@annotation(com.geoway.design.biz.annotation.OpLog)")
    public void logPointCut() {
    }

    @Before(value="logPointCut()")
    public void beforeExec(JoinPoint joinPoint) {
        OpLog opLog = this.getAnnotationLog(joinPoint);
        OpLog.OpType opType = opLog.opType();
        opLog.opType();
        if (opType.equals((Object)OpLog.OpType.loginout)) {
            this.afterExec(joinPoint, null);
        }
    }

    @AfterReturning(pointcut="logPointCut()", returning="rvt")
    public void afterExec(JoinPoint joinPoint, Object rvt) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            OpLog opLog = this.getAnnotationLog(joinPoint);
            if (opLog == null) {
                return;
            }
            SsoUser sysUser = SessionUtils.getUser((HttpServletRequest)request, null);
            if (sysUser == null) {
                sysUser = this.oauth2Service.queryCurrentSsoUser(request);
            }
            if (sysUser == null) {
                log.error("************\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f************");
                return;
            }
            String methodName = joinPoint.getSignature().getName();
            String typeName = joinPoint.getSignature().getDeclaringTypeName();
            int begin = typeName.lastIndexOf(".") + 1;
            String methodFullName = typeName.substring(begin) + "." + methodName;
            Map map = request.getParameterMap();
            LinkedHashMap<String, String> newParamsMap = new LinkedHashMap<String, String>();
            for (String key : map.keySet()) {
                String newVal = ArrayUtil.join((Object[])((Object[])map.get(key)), (CharSequence)",");
                newParamsMap.put(key, newVal);
            }
            String params = JSON.toJSONString(newParamsMap);
            SysOplog sysOplog = new SysOplog();
            sysOplog.setName(opLog.name());
            sysOplog.setDetail(opLog.detail());
            sysOplog.setOptype(opLog.opType().toString());
            sysOplog.setMethod(methodFullName);
            sysOplog.setParam(params);
            sysOplog.setCreatetime(new Date());
            String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
            sysOplog.setMachineName(this.getMachineName(request));
            sysOplog.setIp(ip);
            sysOplog.setSystemid("1");
            sysOplog.setUserid(sysUser.getId());
            sysOplog.setUsername(sysUser.getUserName());
            String appIdNew = this.appId;
            if (newParamsMap.containsKey("appId")) {
                appIdNew = (String)newParamsMap.get("appId");
            }
            sysOplog.setAppid(this.appId);
            this.sysOplogService.save(sysOplog);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    private OpLog getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(OpLog.class);
        }
        return null;
    }

    private String getMachineName(HttpServletRequest request) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception e) {
            return "Administrator";
        }
    }
}

