/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.design.base.base.dto.BaseResponse;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class AdminLoginFilter
implements Filter {
    private AccessTokenManager accessTokenManager;
    private List<String> adminURLS = new ArrayList<String>();

    public void setAdminURLS(List<String> adminURLS) {
        this.adminURLS = adminURLS;
    }

    public void setAccessTokenManager(AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String reqUrl = httpRequest.getServletPath();
        if (this.matchUrls(reqUrl) && !this.isAccessAllowed(httpRequest, httpResponse = (HttpServletResponse)response)) {
            return;
        }
        chain.doFilter(request, response);
    }

    protected boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(200);
            return true;
        }
        String accessToken = CommonLoginUserUtil.getToken();
        if (StrUtil.isEmpty((CharSequence)accessToken)) {
            this.markNoPermissionResponse(response);
            return false;
        }
        SsoUser ssoUser = null;
        AccessTokenContent accessTokenContent = this.accessTokenManager.get(accessToken);
        if (accessTokenContent != null) {
            ssoUser = accessTokenContent.getUser();
        }
        if (ssoUser == null || ssoUser.getUserCatalog() != 1 && ssoUser.getUserCatalog() != 2) {
            this.markNoPermissionResponse(response);
            return false;
        }
        return true;
    }

    private boolean matchUrls(String url) {
        if (this.adminURLS == null || this.adminURLS.size() == 0) {
            return false;
        }
        Map<Boolean, List<String>> map = this.adminURLS.stream().collect(Collectors.partitioningBy(u -> u.endsWith("/*")));
        List<String> urlList = map.get(false);
        for (String fullUrl : urlList) {
            if (!fullUrl.trim().equals(url)) continue;
            return true;
        }
        urlList = map.get(true);
        for (String matchUrl : urlList) {
            if (!url.startsWith(matchUrl.trim().replace("/*", ""))) continue;
            return true;
        }
        return false;
    }

    protected void markNoPermissionResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.markFailure();
        baseResponse.setMessage("\u8be5\u7528\u6237\u6ca1\u6709\u7ba1\u7406\u5458\u6743\u9650");
        String jsonResult = JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }
}

