/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.scheduled;

import com.geoway.design.biz.service.sys.SysOplogBackupService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="scheduled.oplogBackup", name={"enabled"}, havingValue="true")
public class LogBackupScheduled {
    @Resource
    private SysOplogBackupService sysOplogBackupService;

    @Scheduled(cron="${scheduled.oplogBackup.cron}")
    public void backupYesterday() throws Exception {
        String dateStr = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        this.sysOplogBackupService.backup(dateStr);
    }
}

