/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.enums.UserSysEnum;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.service.dev.ILoginService;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLoginServiceImpl
implements ILoginService {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private ICaptchaService commonService;

    @Override
    public String getUserSys() {
        return UserSysEnum.JCKJ.value;
    }

    @Override
    public abstract Result<SsoUser> login(String var1, String var2, String var3, String var4, String var5, HttpServletRequest var6);

    @Override
    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        return this.login(username, password, "", uuid, code, req);
    }

    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser> result = this.login(username, password, null, null, null, null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        Result result = Oauth2Utils.revokeAccessToken((String)this.projectConfig.getSsoServerUrl(), (String)access_token);
        return result.isSuccess();
    }

    @Override
    public boolean checkIsResetPassword(String userId) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateCaptcha(String uuid, String code) {
        try {
            if (StrUtil.isEmpty((CharSequence)uuid) && StrUtil.isEmpty((CharSequence)code)) {
                return;
            }
            String captcha = this.commonService.queryCaptcha(uuid);
            if (!this.commonService.validateCaptcha(code, captcha)) {
                throw new RuntimeException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bd5\u8bd5!");
            }
        }
        finally {
            this.commonService.removeCaptcha(uuid);
        }
    }
}

