/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.dev.impl.AbstractLoginServiceImpl;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class LocalLoginServiceImpl
extends AbstractLoginServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LocalLoginServiceImpl.class);
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Value(value="${password.forceChangeInitPWD:true}")
    private Boolean forceChangeInitPWD;
    @Value(value="${password.security.enable:false}")
    private Boolean securityEnable;
    @Value(value="${password.security.expireDays:90}")
    private int expireDays;
    @Value(value="${password.security.failureTimes:5}")
    private int allowFailureTimes;
    @Value(value="${password.security.autoUnlockTime:30}")
    private int autoUnlockMinute;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public Result<SsoUser> login(String username, String password, String tel, String uuid, String code, HttpServletRequest req) {
        this.validateCaptcha(uuid, code);
        return this.checkLogin(username, password, tel, null);
    }

    @Override
    public boolean checkIsResetPassword(String userId) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            return false;
        }
        return this.forceChangeInitPWD != false && StrUtil.isNotBlank((CharSequence)sysUserSecurity.getResetPassword());
    }

    protected Result<SsoUser> checkLogin(String username, String password, String tel, List<String> sources) {
        SsoUser ssoUser = new SsoUser();
        try {
            int iCount;
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUser::getAccout, (Object)username);
            if (StrUtil.isNotBlank((CharSequence)tel)) {
                queryWrapper.eq(SysUser::getTelEncrypt, (Object)AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
            }
            if ((iCount = this.sysUserMapper.selectCount((Wrapper)queryWrapper).intValue()) == 0) {
                queryWrapper.clear();
                queryWrapper.and(gw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)gw.eq(SysUser::getName, (Object)username)).or()).eq(SysUser::getAccout, (Object)username)).or()).eq(SysUser::getAname, (Object)username);
                });
                if (StrUtil.isNotBlank((CharSequence)tel)) {
                    queryWrapper.eq(SysUser::getTel, (Object)tel);
                }
            }
            if (sources != null && sources.size() != 0) {
                queryWrapper.and(gw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)gw.in(SysUser::getSource, (Collection)sources);
                });
            }
            queryWrapper.last(" limit 1");
            SysUser user = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
            if (user == null || user.getId() == null) {
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            }
            if (!user.getStatus().toString().equals("1")) {
                return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            Date now = new Date();
            SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)user.getId()));
            if (sysUserSecurity == null) {
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef\u3002");
            }
            if (sysUserSecurity.getLock() != null && sysUserSecurity.getLock() == 1) {
                if (sysUserSecurity.getUnlocktime() != null && sysUserSecurity.getUnlocktime().before(now)) {
                    sysUserSecurity.unlock();
                    LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                    updateWrapper.set(SysUserSecurity::getLock, (Object)0);
                    updateWrapper.set(SysUserSecurity::getFailedtimes, (Object)0);
                    updateWrapper.set(SysUserSecurity::getUnlocktime, null);
                    updateWrapper.eq(SysUserSecurity::getId, (Object)user.getId());
                    this.sysUserSecurityMapper.update(null, (Wrapper)updateWrapper);
                } else {
                    if (sysUserSecurity.getUnlocktime() != null) {
                        String timeMsg = DateUtil.format((Date)sysUserSecurity.getUnlocktime(), (String)"yyyy-MM-dd HH:mm:ss");
                        return Result.createError((String)("\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u7cfb\u7edf\u5c06\u4e8e" + timeMsg + "\u540e\u81ea\u52a8\u89e3\u9501"));
                    }
                    return Result.createError((String)"\u7528\u6237\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
                }
            }
            boolean errTimesArrived = false;
            if (!this.passwordUtil.getMD5Password(password).equals(sysUserSecurity.getPassword())) {
                if (this.securityEnable.booleanValue()) {
                    sysUserSecurity.setLastfailedtime(new Date());
                    sysUserSecurity.addOneFailureTimes();
                    this.sysUserSecurityMapper.updateById(sysUserSecurity);
                    errTimesArrived = this.checkedIsErrpasswordInDuration(user.getId());
                    if (errTimesArrived) {
                        sysUserSecurity.lock(this.autoUnlockMinute);
                        this.sysUserSecurityMapper.updateById(sysUserSecurity);
                        String key = "errPwdTimes-" + user.getId();
                        this.redisTemplate.delete((Object)key);
                    }
                }
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef\u3002");
            }
            if (this.securityEnable.booleanValue()) {
                long expireT;
                boolean isExipred;
                long timeT = System.currentTimeMillis() - sysUserSecurity.getCreatetime().getTime();
                boolean bl = isExipred = timeT > (expireT = (long)this.expireDays * 24L * 3600000L);
                if (sysUserSecurity.getExpiretime() != null && sysUserSecurity.getExpiretime().getTime() > System.currentTimeMillis()) {
                    isExipred = true;
                }
                if (isExipred) {
                    return Result.createResetPassword((String)("\u5bc6\u7801\u5df2\u8fc7\u671f\u6216\u8d85\u8fc7" + this.expireDays + "\u5929\u672a\u4fee\u6539\uff0c\u9700\u8981\u4fee\u6539\u5bc6\u7801\u624d\u80fd\u4f7f\u7528!"));
                }
            }
            List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
            String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
            String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
            ssoUser.setId(user.getId());
            ssoUser.setUserid(user.getId());
            ssoUser.setUserName(user.getAname());
            ssoUser.setLoginName(user.getAccout());
            ssoUser.setRegionCode(regionCode);
            ssoUser.setRegionName(regionName);
            ssoUser.setUserCatalog(user.getCatalog());
            ssoUser.setSource(this.getUserSys());
            return Result.createSuccess((Object)ssoUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean checkedIsErrpasswordInDuration(String useId) {
        boolean tag = false;
        String key = "errPwdTimes-" + useId;
        boolean hasKey = this.redisTemplate.hasKey((Object)key);
        if (hasKey) {
            String strNum = (String)this.redisTemplate.opsForValue().get((Object)key);
            Integer num = Integer.parseInt(strNum);
            if (num >= this.allowFailureTimes) {
                tag = true;
            } else {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                this.redisTemplate.opsForValue().set((Object)key, (Object)(num + ""));
            }
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)"1");
            this.redisTemplate.expire((Object)key, 5L, TimeUnit.MINUTES);
        }
        return tag;
    }
}

