/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserOrganization;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LocalOrganizationServiceImpl
extends ServiceImpl<SysOrganizationMapper, SysOrganization>
implements IOrganizationService {
    @Autowired
    SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    IUserOrganizationService sysUserOrganizationService;
    @Autowired
    @Qualifier(value="localUserServiceImpl")
    IUserService sysUserService;

    @Override
    public void saveOrUp(SysOrganization org) throws Exception {
        if (StrUtil.isBlank((CharSequence)org.getPid())) {
            org.setPid("0");
        }
        SysOrganization pOrg = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)org.getPid()));
        boolean isAdd = false;
        if (StrUtil.isBlank((CharSequence)org.getId())) {
            isAdd = true;
            Integer maxOrder = this.sysOrganizationMapper.queryMaxOrderByPid(org.getPid());
            int order = maxOrder == null ? 1 : maxOrder + 1;
            org.setOrder(order);
            int level = pOrg == null ? 1 : pOrg.getLevel() + 1;
            org.setLevel(level);
            String parents = "";
            if (pOrg != null) {
                parents = StrUtil.isNotBlank((CharSequence)pOrg.getParents()) ? pOrg.getId() : pOrg.getParents() + "/" + pOrg.getId();
            }
            org.setParents(parents);
        } else {
            isAdd = false;
            SysOrganization oldOrg = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)org.getId()));
            org.setParents(oldOrg.getParents());
            org.setLevel(oldOrg.getLevel());
            if (!org.getName().equals(oldOrg.getName())) {
                this.buildChildALlName(org);
            }
        }
        this.buildAllName(org);
        if (isAdd) {
            this.sysOrganizationMapper.insert(org);
        } else {
            this.sysOrganizationMapper.updateById(org);
        }
    }

    @Override
    public void batchSave(List<SysOrganization> orgs) throws Exception {
        for (SysOrganization org : orgs) {
            this.saveOrUp(org);
        }
    }

    @Override
    public List<SysOrganization> queryTree(String filterParam) throws Exception {
        List<SysOrganization> list = this.queryList(filterParam);
        this.bindUsersToOrg(list);
        return this.constructTree(list);
    }

    @Override
    public List<SysOrganization> queryTreeNoUser(String filterParam) throws Exception {
        List<SysOrganization> list = this.queryList(filterParam);
        return this.constructTree(list);
    }

    @Override
    public List<SysOrganization> queryList(String filterParam) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysOrganization.class);
        List list = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<SysOrganization> queryListById(String id) throws Exception {
        if (id == null) {
            throw new Exception("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<SysOrganization> list = this.sysOrganizationMapper.getOrgListById(id);
        this.bindUsersToOrg(list);
        return this.constructTree(list);
    }

    @Override
    public List<SysOrganization> queryListByName(String name) throws Exception {
        List<SysOrganization> list = this.sysOrganizationMapper.getOrgListByName(name);
        this.bindUsersToOrg(list);
        return this.constructTree(list);
    }

    @Override
    public List<SysOrganization> queryAllParentOrg(String id) {
        if (id == null) {
            throw new ServiceException("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<SysOrganization> result = this.sysOrganizationMapper.getAllParentOrg(id);
        Collections.reverse(result);
        return result;
    }

    @Override
    public IPage<SysOrganization> queryPage(String filterParam, int page, int size) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysOrganization.class);
        Page pages = new Page((long)page, (long)size);
        Page results = (Page)this.sysOrganizationMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        return results;
    }

    @Override
    public SysOrganization findOneById(String id, String filterParam) throws Exception {
        SysOrganization org = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pid_EQ_" + id;
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysOrganization.class);
        List orgs = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        if (org != null) {
            org.setChildren(orgs);
        }
        return org;
    }

    @Override
    public SysOrganization findOneByName(String name, String filterParam) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysOrganization::getName, (Object)name);
        SysOrganization org = (SysOrganization)this.sysOrganizationMapper.selectOne((Wrapper)wrapper);
        if (org == null) {
            return org;
        }
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pid_EQ_" + org.getId();
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysOrganization.class);
        List orgs = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        if (org != null) {
            org.setChildren(orgs);
        }
        return org;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteById(id);
        }
    }

    @Override
    public void bindUsers(String orgId, String userIds) {
        this.sysUserOrganizationService.removeByOrgUserId(orgId, null);
        if (StrUtil.isBlank((CharSequence)userIds)) {
            return;
        }
        String[] userIdArr = userIds.split(",");
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (String userId : userIdArr) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        this.sysUserOrganizationService.saveBatch(userOrgs);
    }

    @Override
    public void bindOneUser(String orgId, String userId) {
        this.sysUserOrganizationService.removeByOrgUserId(orgId, userId);
        SysUserOrganization userOrg = new SysUserOrganization();
        userOrg.setUserid(userId);
        userOrg.setOrgid(orgId);
        this.sysUserOrganizationService.saveOne(userOrg);
    }

    @Override
    public void removeBindUser(String orgId, String userIds) {
        String[] userIdArr;
        for (String userId : userIdArr = userIds.split(",")) {
            this.sysUserOrganizationService.removeByOrgUserId(orgId, userId);
        }
    }

    @Override
    public List<SysUser> queryRelUsers(String orgId) {
        List<SysUserOrganization> organizations = this.sysUserOrganizationService.queryByOrgId(orgId);
        return this.sysUserService.query(organizations.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
    }

    @Override
    public List<SysUser> queryNonOrgUsers() {
        try {
            List<SysUser> allUsers = this.sysUserService.queryList("");
            List<SysUserOrganization> organizations = this.sysUserOrganizationService.queryList("");
            List orgUserIds = organizations.stream().map(f -> f.getUserid()).collect(Collectors.toList());
            return allUsers.stream().filter(f -> !orgUserIds.contains(f.getId())).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        int count = 0;
        if (filterParam == null) {
            filterParam = "";
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysOrganization.class);
        count = this.sysOrganizationMapper.selectCount((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public List<SysOrganization> queryUserOrgs(String userId) {
        return this.sysOrganizationMapper.queryUserOrgs(userId);
    }

    @Override
    public void bindUsersToOrg(List<SysOrganization> list) {
        ArrayList<SysUser> subUsers;
        String orgId;
        List<SysUserOrganization> userOrgs = this.sysUserOrganizationService.queryList("");
        List<String> userIds = userOrgs.stream().map(f -> f.getUserid()).collect(Collectors.toList());
        List<SysUser> users = this.sysUserService.query(userIds);
        if (users.isEmpty() || userOrgs.isEmpty()) {
            return;
        }
        HashMap sysUserMap = new HashMap();
        users.forEach(f -> sysUserMap.put(f.getId(), f));
        HashMap mapUser = new HashMap();
        Map<String, List<SysUserOrganization>> groupedUserOrgs = userOrgs.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getOrgid())).collect(Collectors.groupingBy(SysUserOrganization::getOrgid));
        for (Map.Entry<String, List<SysUserOrganization>> kv : groupedUserOrgs.entrySet()) {
            orgId = kv.getKey();
            subUsers = new ArrayList();
            mapUser.put(orgId, subUsers);
            kv.getValue().forEach(f -> {
                if (sysUserMap.containsKey(f.getUserid())) {
                    subUsers.add((SysUser)sysUserMap.get(f.getUserid()));
                }
            });
        }
        for (SysOrganization org : list) {
            orgId = org.getId();
            if (!mapUser.containsKey(orgId)) continue;
            subUsers = (List)mapUser.get(orgId);
            org.setBindUsers(subUsers);
        }
    }

    private void deleteById(String id) throws Exception {
        int iCount = this.sysUserOrganizationService.queryByOrgId(id).size();
        if (iCount > 0) {
            throw new Exception("\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
        }
        this.sysOrganizationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public List<SysOrganization> constructTree(List<SysOrganization> list) {
        int minLevel = 99;
        HashMap mapParam = new HashMap();
        for (SysOrganization org : list) {
            String key = org.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(org);
                } else {
                    ArrayList<SysOrganization> childList = new ArrayList<SysOrganization>();
                    childList.add(org);
                    mapParam.put(key, childList);
                }
            }
            if (org.getLevel() >= minLevel) continue;
            minLevel = org.getLevel();
        }
        ArrayList<SysOrganization> results = new ArrayList<SysOrganization>();
        for (SysOrganization org : list) {
            String key = org.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                org.setChildren((List)mapParam.get(key));
                org.setChildCount(LocalOrganizationServiceImpl.doCount(org));
            }
            if (org.getLevel() != minLevel) continue;
            results.add(org);
        }
        return results;
    }

    private static Integer doCount(SysOrganization org) {
        List<SysOrganization> orgList = org.getChildren();
        Integer sum = 0;
        if (orgList == null || orgList.size() == 0) {
            if (org.getChildCount() > 0) {
                return org.getChildCount();
            }
            return sum;
        }
        if (orgList != null && orgList.size() > 0) {
            for (SysOrganization child : orgList) {
                Integer numCount = orgList.size() + org.getChildCount();
                sum = sum + numCount;
                LocalOrganizationServiceImpl.doCount(child);
            }
        }
        return sum;
    }

    private void buildChildALlName(SysOrganization org) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.like(SysOrganization::getParents, (Object)org.getId());
        List orgs = this.sysOrganizationMapper.selectList((Wrapper)wrapper);
        for (SysOrganization subOrg : orgs) {
            this.buildAllName(subOrg);
        }
    }

    private void buildAllName(SysOrganization org) {
        String parents = org.getParents();
        if (StrUtil.isBlank((CharSequence)parents)) {
            org.setAllname(org.getName());
        } else {
            List<String> pOrgIds = Arrays.asList(parents.split("/"));
            List pOrgs = this.sysOrganizationMapper.selectBatchIds(pOrgIds);
            String allName = "";
            for (SysOrganization pOrg : pOrgs) {
                allName = allName + pOrg.getName() + "/";
            }
            allName = allName + org.getName();
            org.setAllname(allName);
        }
    }
}

