/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysUserOrganization;
import com.geoway.design.biz.mapper.SysUserOrganizationMapper;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalUserOrganizationServiceImpl
extends ServiceImpl<SysUserOrganizationMapper, SysUserOrganization>
implements IUserOrganizationService {
    @Autowired
    private SysUserOrganizationMapper sysUserOrganizationMapper;

    @Override
    @OpLog(name="\u4fee\u6539\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", opType=OpLog.OpType.update)
    public void updateUserOrg(String userId, List<String> orgIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getUserid, (Object)userId);
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
        if (orgIds == null) {
            return;
        }
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (String orgId : orgIds) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        if (userOrgs.size() > 0) {
            for (SysUserOrganization userOrg : userOrgs) {
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }
    }

    @Override
    public void updateOrgUsers(String orgId, List<String> userIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (String userId : userIds) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        if (userOrgs.size() > 0) {
            for (SysUserOrganization userOrg : userOrgs) {
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }
    }

    @Override
    public void saveBatch(List<SysUserOrganization> userOrgs) {
        super.saveBatch(userOrgs);
    }

    @Override
    public void saveOne(SysUserOrganization userOrg) {
        this.sysUserOrganizationMapper.insert(userOrg);
    }

    @Override
    public void removeByOrgUserId(String orgId, String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)orgId)) {
            wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        }
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            wrapper.eq(SysUserOrganization::getUserid, (Object)userId);
        }
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
    }

    @Override
    public List<SysUserOrganization> queryByOrgId(String orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        return this.sysUserOrganizationMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<SysUserOrganization> queryList(String filterParam) {
        try {
            MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysPermission.class);
            return this.sysUserOrganizationMapper.selectList((Wrapper)queryWrapper);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

