/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.enums.UserSysEnum;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.ExcelUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.encryption.Md5Utils;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.SysImage;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserLimit;
import com.geoway.design.biz.entity.SysUserRegion;
import com.geoway.design.biz.entity.SysUserRegister;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysRoleMapper;
import com.geoway.design.biz.mapper.SysUserLimitMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserRegisterMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.biz.service.sys.ISysUserRegisterService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.util.PasswordUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(LocalUserServiceImpl.class);
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private IUserOrganizationService sysUserOrganizationService;
    @Autowired
    private ISysUserRegionService sysUserRegionService;
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private IFunctionSysService.ISysUserSecurityService sysUserSecurityService;
    @Autowired
    private IApplicationSysService.ISysImageService sysImageService;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    private SysUserRegisterMapper sysUserRegisterMapper;
    @Autowired
    private SysUserLimitMapper sysUserLimitMapper;
    @Value(value="${password.initPassword:123456}")
    private String initPassword;
    @Value(value="${password.randomPassword:false}")
    private boolean isRandomPassword;
    @Value(value="${password.encryptMethod:MD5}")
    private String encryptMethod;
    @Value(value="${userTel.encrypt:true}")
    private boolean userTelEncrypt;
    @Autowired
    private ISysUserRegisterService userRegisterService;

    @Override
    public String getUserSys() {
        return UserSysEnum.JCKJ.value;
    }

    @Override
    public Boolean isSync() {
        return false;
    }

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            this.saveUserBaseInfo(user, file, deletePhoto);
            this.saveUserRelInfo(user);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void saveUserRelInfo(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
                this.sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
                this.sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
    }

    protected void saveUserBaseInfo(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            int iCount;
            boolean isAdd = false;
            if (StrUtil.isBlank((CharSequence)user.getName())) {
                throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String tel = user.getTel();
            if (StrUtil.isBlank((CharSequence)tel)) {
                throw new RuntimeException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tel.length() != 11) {
                throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
            }
            if (this.userTelEncrypt) {
                user.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));
            }
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUser::getAccout, (Object)user.getAccout());
            if (StrUtil.isBlank((CharSequence)user.getId())) {
                wrapper.eq(SysUser::getSource, (Object)user.getSource());
                isAdd = true;
                user.setCreatetime(new Date());
                if (this.userTelEncrypt && StrUtil.isBlank((CharSequence)user.getTelEncrypt())) {
                    user.setTelEncrypt(AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
                }
            } else {
                SysUser old = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)user.getId()));
                wrapper.ne(SysUser::getId, (Object)user.getId());
                wrapper.eq(SysUser::getSource, (Object)old.getSource());
                if (old != null) {
                    user.setCreatetime(old.getCreatetime());
                    user.setUpdatetime(new Date());
                    user.setSource(old.getSource());
                    if (this.userTelEncrypt) {
                        if (tel.contains("*")) {
                            if (!tel.equals(old.getTel())) {
                                throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
                            }
                        } else {
                            user.setTelEncrypt(AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
                        }
                    }
                }
            }
            if ((iCount = this.sysUserMapper.selectCount((Wrapper)wrapper).intValue()) > 0) {
                throw new RuntimeException("\u8d26\u6237:" + user.getAccout() + "  \u5df2\u5b58\u5728\uff01");
            }
            if (StrUtil.isBlank((CharSequence)user.getAname())) {
                user.setAname(user.getName());
            }
            if (!isAdd && deletePhoto) {
                this.sysImageService.removeById((Serializable)((Object)user.getImgid()));
                user.setImgid("");
            }
            if (isAdd) {
                this.sysUserMapper.insert(user);
            } else {
                this.sysUserMapper.updateById(user);
            }
            if (file != null && !file.isEmpty()) {
                SysImage sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)user.getImgid()));
                if (sysImage == null) {
                    sysImage = new SysImage();
                    sysImage.setObjectid(user.getId());
                    sysImage.setType(3);
                }
                sysImage.setImage(file.getBytes());
                this.sysImageService.saveOrUpdate(sysImage);
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysUser::getImgid, (Object)sysImage.getId());
                updateWrapper.eq(SysUser::getId, (Object)user.getId());
                this.sysUserMapper.update(null, (Wrapper)updateWrapper);
            }
            if (isAdd) {
                String password;
                String resetPassword = "";
                if (StrUtil.isNotBlank((CharSequence)user.getPassword())) {
                    password = user.getPassword();
                } else {
                    resetPassword = this.initPassword;
                    if (this.isRandomPassword) {
                        resetPassword = this.getRandomPassword();
                    }
                    password = Md5Utils.getMD5Str((String)resetPassword, (String)"UTF-8");
                }
                this.setPassword(user.getId(), password, resetPassword);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void batchSave(List<SysUser> users) {
        for (SysUser user : users) {
            this.saveOrUp(user, null, false);
        }
    }

    @Override
    public SysUser query(String userId) {
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        this.wrapperRoleAllNames(Collections.singletonList(sysUser));
        this.wrapperOrgAllNames(Collections.singletonList(sysUser));
        this.wrapperRegionAllNames(Collections.singletonList(sysUser));
        return sysUser;
    }

    @Override
    public List<SysUser> query(List<String> userIds) {
        ArrayList<SysUser> restult = new ArrayList<SysUser>();
        if (userIds.isEmpty()) {
            return restult;
        }
        List idGroups = Lists.partition(userIds, (int)10000);
        for (List ids : idGroups) {
            restult.addAll(this.sysUserMapper.selectBatchIds(ids));
        }
        return restult;
    }

    @Override
    public List<SysUser> queryList(String filterParam) {
        return this.queryList(filterParam, true);
    }

    @Override
    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        try {
            MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            queryWrapper.orderByDesc((Object)"f_createtime");
            List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            if (withRoleOrg) {
                this.wrapperRoleAllNames(users);
                this.wrapperOrgAllNames(users);
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int queryCount(String filterParam) {
        try {
            MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            return this.sysUserMapper.selectCount((Wrapper)queryWrapper);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size) {
        try {
            filterParam = this.convertTelParam(filterParam);
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            queryWrapper.leftJoin(SysUserSecurity.class, "sus", SysUserSecurity::getId, SysUser::getId);
            queryWrapper.selectAll(SysUser.class);
            queryWrapper.selectAs("sus", SysUserSecurity::getResetPassword, SysUser::getResetPassword);
            queryWrapper.orderByDesc(SysUser::getCreatetime);
            queryWrapper.orderByAsc(SysUser::getName);
            Page pages = new Page((long)page, (long)size);
            IPage pageUsers = this.sysUserMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
            List users = pageUsers.getRecords();
            this.wrapperRoleAllNames(users);
            this.wrapperOrgAllNames(users);
            this.wrapperRegionAllNames(users);
            return pageUsers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String convertTelParam(String filterParam) throws Exception {
        if (StrUtil.isBlank((CharSequence)filterParam)) {
            return filterParam;
        }
        if (!this.userTelEncrypt) {
            return filterParam;
        }
        String telStr = "tel_EQ_";
        String telEncryptStr = "telEncrypt_EQ_";
        if (!filterParam.contains(telStr)) {
            return filterParam;
        }
        int index = filterParam.indexOf(telStr);
        String sub1 = filterParam.substring(index);
        int i1 = sub1.indexOf(";");
        int i2 = sub1.indexOf(")");
        String sub2 = sub1;
        if (i1 > 0 || i2 > 0) {
            sub2 = i1 > 0 && i2 > 0 ? sub1.substring(0, Math.min(i1, i2)) : sub1.substring(0, Math.max(i1, i2));
        }
        String telValue = sub2.replace(telStr, "");
        String encryptValue = AESUtils.encrypt((String)telValue, (String)"FWAijk4A2Dwt2MKw");
        return filterParam.replace(sub2, telEncryptStr + encryptValue);
    }

    @Override
    public void delete(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new RuntimeException("\u4f20\u9012\u7684\u3010id\u3011\u4e3a\u7a7a\uff01");
        }
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)id));
        LambdaQueryWrapper uerRoleWarpper = Wrappers.lambdaQuery();
        uerRoleWarpper.eq(SysUserRole::getUserid, (Object)id);
        this.sysUserRoleService.remove((Wrapper)uerRoleWarpper);
        this.sysUserOrganizationService.removeByOrgUserId("", id);
        LambdaQueryWrapper uerRegionWarpper = Wrappers.lambdaQuery();
        uerRegionWarpper.eq(SysUserRegion::getUserid, (Object)id);
        this.sysUserRegionService.remove((Wrapper)uerRegionWarpper);
        this.sysUserMapper.deleteById((Serializable)((Object)id));
        this.sysUserSecurityService.removeById((Serializable)((Object)id));
        if (StrUtil.isNotBlank((CharSequence)sysUser.getImgid())) {
            this.sysImageService.removeById((Serializable)((Object)sysUser.getImgid()));
        }
        this.sysUserRegisterMapper.delete((Wrapper)Wrappers.lambdaQuery(SysUserRegister.class).eq(SysUserRegister::getName, (Object)sysUser.getName()));
        LambdaQueryWrapper uerLimitWarpper = Wrappers.lambdaQuery();
        uerLimitWarpper.eq(SysUserLimit::getUserid, (Object)id);
        this.sysUserLimitMapper.delete((Wrapper)uerLimitWarpper);
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        try {
            MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            List users = new ArrayList();
            queryWrapper.orderByAsc((Object)"f_name");
            if (!isTemplate.booleanValue()) {
                users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            }
            ExcelUtil.exportExcel(users, null, (String)"\u7528\u6237\u5217\u8868", SysUser.class, (String)"\u5bfc\u51fa\u7528\u6237\u4fe1\u606f", (boolean)true, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        try {
            if (StringUtils.isNull(userList) || userList.size() == 0) {
                throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int successNum = 0;
            int failureNum = 0;
            StringBuilder successMsg = new StringBuilder();
            StringBuilder failureMsg = new StringBuilder();
            Date now = new Date();
            for (SysUser user : userList) {
                try {
                    LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                    wrapper.eq(SysUser::getAccout, (Object)user.getAccout());
                    SysUser oldUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)wrapper);
                    if (ObjectUtil.isNull((Object)oldUser)) {
                        this.saveExcelUser(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5bfc\u5165\u6210\u529f");
                        continue;
                    }
                    if (isUpdateSupport.booleanValue()) {
                        user.setId(oldUser.getId());
                        this.saveExcelUser(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u66f4\u65b0\u6210\u529f");
                        continue;
                    }
                    failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5df2\u5b58\u5728");
                }
                catch (Exception ex) {
                    String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg + ex.getMessage());
                    log.error(msg, (Throwable)ex);
                }
            }
            if (failureNum > 0) {
                failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
                throw new ServiceException(failureMsg.toString());
            }
            successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
            return successMsg.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        SysUserSecurity userSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)userId));
        if (userSecurity == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u7528\u6237\u5b89\u5168\u4fe1\u606f");
        }
        if (!userSecurity.getPassword().equals(this.passwordUtil.getMD5Password(oldPwd))) {
            throw new RuntimeException("\u7528\u6237\u539f\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u5bc6\u7801");
        }
        if (userSecurity.getPassword().equals(this.passwordUtil.getMD5Password(newPwd))) {
            throw new RuntimeException("\u65b0\u5bc6\u7801\u548c\u539f\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        userSecurity.setResetPassword("");
        userSecurity.setPassword(this.passwordUtil.getMD5Password(newPwd));
        this.sysUserSecurityMapper.updateById(userSecurity);
    }

    @Override
    public void changePassword(String userId, String password) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(this.passwordUtil.getMD5Password(password));
        this.sysUserSecurityService.saveOrUpdate(sysUserSecurity);
    }

    @Override
    public String resetUserPassword(String userId) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            throw new RuntimeException("\u8be5\u7528\u6237\u4e0d\u652f\u6301\u5bc6\u7801\u91cd\u7f6e");
        }
        String resetPassword = this.getRandomPassword();
        String password = Md5Utils.getMD5Str((String)resetPassword, (String)"UTF-8");
        sysUserSecurity.setResetPassword(resetPassword);
        sysUserSecurity.setPassword(password);
        this.sysUserSecurityService.saveOrUpdate(sysUserSecurity);
        return resetPassword;
    }

    private String entryPassword(String password) {
        String entryPassword = password;
        if (this.encryptMethod.equalsIgnoreCase("MD5")) {
            entryPassword = Md5Utils.getMD5Str((String)password, (String)"UTF-8");
        } else {
            try {
                entryPassword = AESUtils.encrypt((String)password, (String)"FWAijk4A2Dwt2MKw");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entryPassword;
    }

    private void setPassword(String userId, String password, String resetPassword) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(password);
        sysUserSecurity.setResetPassword(resetPassword);
        this.sysUserSecurityService.saveOrUpdate(sysUserSecurity);
    }

    private void saveExcelUser(SysUser sysUser) {
        try {
            this.saveOrUp(sysUser, null, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void wrapperRoleAllNames(List<SysUser> users) {
        HashMap allNameCache = new HashMap();
        for (SysUser user : users) {
            List<SysRole> roles = this.sysRoleMapper.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoleNames(roleAllNames);
            user.setRoles(roles);
        }
    }

    private void wrapperOrgAllNames(List<SysUser> users) {
        for (SysUser user : users) {
            ArrayList<String> orgAllNames = new ArrayList<String>();
            List<SysOrganization> orgs = this.sysOrganizationMapper.queryUserOrgs(user.getId());
            for (SysOrganization org : orgs) {
                List<SysOrganization> parentOrg = this.organizationService.queryAllParentOrg(org.getId());
                orgAllNames.add(StrUtil.join((CharSequence)"/", (Object[])new Object[]{parentOrg.stream().map(SysOrganization::getName).collect(Collectors.toList())}));
            }
            user.setOrgNames(orgAllNames);
            user.setOrganizations(orgs);
        }
    }

    private void wrapperRegionAllNames(List<SysUser> users) {
        for (SysUser user : users) {
            ArrayList<String> allRegionNames = new ArrayList<String>();
            List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
            for (SysRegion region : regions) {
                List<SysRegion> parentRegion = this.sysRegionMapper.getAllParentRegion(region.getCode());
                Collections.reverse(parentRegion);
                allRegionNames.add(StrUtil.join((CharSequence)"/", (Object[])new Object[]{parentRegion.stream().map(SysRegion::getName).collect(Collectors.toList())}));
            }
            user.setRegionNames(allRegionNames);
            user.setRegions(regions);
        }
    }

    private String getRandomPassword() {
        int i;
        char[] UPPERCASE = "ABCDEFGHJKMNPQRSTUVWXYZ".toCharArray();
        char[] LOWERCASE = "abcdefghijkmnpqrstuvwxyz".toCharArray();
        char[] NUMBERS = "23456789".toCharArray();
        char[] SPECIALS = "@#".toCharArray();
        Random random = new Random();
        ArrayList<Character> password = new ArrayList<Character>();
        password.add(Character.valueOf(UPPERCASE[random.nextInt(UPPERCASE.length)]));
        for (i = 0; i < 3; ++i) {
            password.add(Character.valueOf(LOWERCASE[random.nextInt(LOWERCASE.length)]));
        }
        for (i = 0; i < 3; ++i) {
            password.add(Character.valueOf(NUMBERS[random.nextInt(NUMBERS.length)]));
        }
        password.add(Character.valueOf(SPECIALS[random.nextInt(SPECIALS.length)]));
        Collections.shuffle(password);
        StringBuilder sb = new StringBuilder();
        Iterator iterator = password.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            sb.append(c);
        }
        return sb.toString();
    }

    private String getRandomCharter(Random random, boolean upperCase) {
        int randomIndex = random.nextInt(26);
        int aa = upperCase ? 65 : 97;
        char randomChar = (char)(randomIndex + aa);
        return String.valueOf(randomChar);
    }

    private String getSpeCharter(Random random) {
        int randomIndex = random.nextInt(3);
        String[] secordArr = new String[]{"@", "#", "$", "!"};
        return secordArr[randomIndex];
    }
}

