/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import com.geoway.design.base.support.ServletUtils;
import com.geoway.design.biz.service.dev.ILoginService;
import com.geoway.design.biz.service.dev.impl.LocalLoginServiceImpl;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LoginSysFactory {
    @Autowired
    @Qualifier(value="userService")
    private LocalLoginServiceImpl defaultService;
    @Resource
    private Map<String, ILoginService> userServiceMap;
    @Autowired
    private IOauth2Service oauth2Service;

    public ILoginService getService(String type) {
        for (Map.Entry<String, ILoginService> entry : this.userServiceMap.entrySet()) {
            String userSys = entry.getValue().getUserSys();
            if (!type.equals(userSys)) continue;
            return entry.getValue();
        }
        return this.defaultService;
    }

    public ILoginService getService() {
        String type = this.getType();
        return this.getService(type);
    }

    private String getType() {
        String type = null;
        try {
            HttpServletRequest request = ServletUtils.getRequest();
            SsoUser ssoUser = this.oauth2Service.queryCurrentSsoUser(request);
            type = ssoUser.getSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }
}

