/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.config.SsoConfigProp;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSysFactory {
    private IUserService defaultService;
    @Resource
    private Map<String, IUserService> userServiceMap;
    @Autowired
    private SsoConfigProp ssoConfig;
    @Autowired
    private IOauth2Service oauth2Service;

    @PostConstruct
    private void setService() {
        this.defaultService = this.getDefaultService();
    }

    public IUserService getService() {
        String userSys = this.getUserSysFromRequest();
        if (StrUtil.isNotBlank((CharSequence)userSys)) {
            return this.getByType(userSys);
        }
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        if (ssoUser != null && StrUtil.isNotBlank((CharSequence)ssoUser.getSource())) {
            return this.getByType(ssoUser.getSource());
        }
        return this.defaultService;
    }

    private String getUserSysFromRequest() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String parameterUserSys = request.getParameter("userSys");
        if (StrUtil.isNotBlank((CharSequence)parameterUserSys)) {
            return parameterUserSys;
        }
        String headerUserSys = request.getHeader("access_user_sys");
        if (StrUtil.isNotBlank((CharSequence)headerUserSys)) {
            return headerUserSys;
        }
        String cookieUserSys = CookieUtils.getCookie((HttpServletRequest)request, (String)"ns-design-userSys");
        if (StrUtil.isNotBlank((CharSequence)cookieUserSys)) {
            return cookieUserSys;
        }
        return null;
    }

    private IUserService getDefaultService() {
        String type = this.ssoConfig.getLoginType();
        String[] split = type.split(",");
        type = split[0];
        return this.getByType(type);
    }

    private IUserService getByType(String type) {
        List<String> syncType = Arrays.asList(this.ssoConfig.getSyncType().split(","));
        for (Map.Entry<String, IUserService> entry : this.userServiceMap.entrySet()) {
            String userSys = entry.getValue().getUserSys();
            Boolean isSync = entry.getValue().isSync();
            boolean flag = syncType.stream().anyMatch(a -> a.equals(userSys));
            if (!type.equals(userSys) || isSync != flag) continue;
            return entry.getValue();
        }
        return this.defaultService;
    }
}

