/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.design.biz.entity.BimOrg;
import com.geoway.design.biz.entity.BimUser;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.hunan.BimOrgService;
import com.geoway.design.biz.service.hunan.BimService;
import com.geoway.design.biz.service.hunan.BimUserService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.iam.Codec.IamFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BimServiceImpl
implements BimService {
    private static final Logger log = LoggerFactory.getLogger(BimServiceImpl.class);
    @Value(value="${hunan.BIM.remoteUser:}")
    private String bimRemoteUser;
    @Value(value="${hunan.BIM.remotePwd:}")
    private String bimRemotePwd;
    @Value(value="${hunan.BIM.secretKey:}")
    private String bimSecretKey;
    @Value(value="${hunan.BIM.roleId:}")
    private String bimRoleId;
    private final String type = "SM4";
    private final String signType = "SM3";
    @Autowired
    BimUserService bimUserService;
    @Autowired
    BimOrgService bimOrgService;
    @Autowired
    ISysUserService userService;
    @Autowired
    IOrganizationService organizationService;
    @Autowired
    ISysUserRegionService sysUserRegionService;
    @Autowired
    ISysUserRoleService sysUserRoleService;
    @Autowired
    IUserOrganizationService userOrganizationService;
    @Autowired
    private RedisTemplate<String, String> bimOrgLevelCache;

    @Override
    public String queryUserOrgSchema(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!this.validPermisson(jsonInfo, resultJSON)) {
                return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
            }
            List<String> mustFieldList = Arrays.asList("username", "tel", "alisname", "xzqdm", "email", "sex", "userid", "usercode", "orgid");
            JSONArray accountJson = new JSONArray();
            for (String fieldName : mustFieldList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("multivalued", (Object)"false");
                jsonObject.put("name", (Object)fieldName);
                jsonObject.put("required", (Object)"true");
                jsonObject.put("type", (Object)"String");
                accountJson.add((Object)jsonObject);
            }
            resultJSON.put("account", (Object)accountJson);
            List<String> mustRoleFieldList = Arrays.asList("orgname", "level", "orgid", "orgcode", "parenetid");
            JSONArray organizationJson = new JSONArray();
            for (String fieldName : mustRoleFieldList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("multivalued", (Object)"false");
                jsonObject.put("name", (Object)fieldName);
                jsonObject.put("required", (Object)"true");
                if ("level".equals(fieldName)) {
                    jsonObject.put("type", (Object)"int");
                } else {
                    jsonObject.put("type", (Object)"String");
                }
                organizationJson.add((Object)jsonObject);
            }
            resultJSON.put("organization", (Object)organizationJson);
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u7528\u6237\u548c\u7ec4\u7ec7\u5c5e\u6027\u5931\u8d25", (Throwable)ex);
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u83b7\u53d6\u7528\u6237\u548c\u7ec4\u7ec7\u5c5e\u6027\u5931\u8d25");
        }
        return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
    }

    @Override
    public String saveUser(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!this.validPermisson(jsonInfo, resultJSON)) {
                return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
            }
            String userId = jsonInfo.getString("userid");
            String username = jsonInfo.getString("username");
            String tel = jsonInfo.getString("tel");
            String alisname = jsonInfo.getString("alisname");
            String email = jsonInfo.getString("email");
            String orgid = jsonInfo.getString("orgid");
            String xzqdm = jsonInfo.getString("xzqdm");
            Integer sex = jsonInfo.getInteger("sex");
            BimUser bimUser = new BimUser();
            if (jsonInfo.containsKey((Object)"bimUid")) {
                userId = jsonInfo.getString("bimUid");
            }
            bimUser.setTel(tel);
            bimUser.setId(userId);
            bimUser.setName(alisname);
            bimUser.setAname(alisname);
            bimUser.setAccout(username);
            bimUser.setEmail(email);
            if (sex != null) {
                bimUser.setSex(sex);
            }
            this.bimUserService.saveBimUser(bimUser);
            if (StrUtil.isNotBlank((CharSequence)this.bimRoleId)) {
                ArrayList<String> roleIds = new ArrayList<String>();
                roleIds.add(this.bimRoleId);
                this.sysUserRoleService.updateUserRole(bimUser.getId(), roleIds);
            }
            if (StrUtil.isNotBlank((CharSequence)xzqdm)) {
                ArrayList<String> xzqdms = new ArrayList<String>();
                xzqdms.add(xzqdm);
                this.sysUserRegionService.updateUserRegions(bimUser.getId(), xzqdms);
            }
            if (StrUtil.isNotBlank((CharSequence)orgid)) {
                ArrayList<String> orgIds = new ArrayList<String>();
                orgIds.add(orgid);
                this.userOrganizationService.updateUserOrg(bimUser.getId(), orgIds);
            }
            resultJSON.put("resultCode", (Object)0);
            resultJSON.put("uid", (Object)bimUser.getId());
            resultJSON.put("message", (Object)"success");
        }
        catch (Exception ex) {
            log.error("\u8d26\u53f7\u521b\u5efa\u5931\u8d25", (Throwable)ex);
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u8d26\u53f7\u521b\u5efa\u5931\u8d25");
        }
        return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
    }

    @Override
    public String deleteUser(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!this.validPermisson(jsonInfo, resultJSON)) {
                return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
            }
            String bimUid = (String)jsonInfo.get((Object)"bimUid");
            this.userService.deleteOne(bimUid);
            resultJSON.put("resultCode", (Object)0);
            resultJSON.put("message", (Object)"success");
        }
        catch (Exception ex) {
            log.error("\u8d26\u53f7\u5220\u9664\u5931\u8d25", (Throwable)ex);
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u8d26\u53f7\u5220\u9664\u5931\u8d25");
        }
        return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
    }

    @Override
    public String saveOrg(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!this.validPermisson(jsonInfo, resultJSON)) {
                return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
            }
            String orgId = jsonInfo.containsKey((Object)"orgid") ? jsonInfo.getString("orgid") : jsonInfo.getString("bimOrgId");
            String orgName = jsonInfo.getString("orgname");
            Integer ilevel = jsonInfo.getInteger("level");
            String orgCode = jsonInfo.getString("orgcode");
            String parentId = jsonInfo.getString("parenetid");
            BimOrg bimOrg = new BimOrg();
            bimOrg.setId(orgId);
            bimOrg.setPid(parentId);
            bimOrg.setName(orgName);
            bimOrg.setAname(orgName);
            int plevel = this.getOrgPlevel(parentId);
            bimOrg.setLevel(plevel + 1);
            bimOrg.setCode(orgCode);
            this.bimOrgService.saveBimOrg(bimOrg);
            resultJSON.put("resultCode", (Object)0);
            resultJSON.put("uid", (Object)bimOrg.getId());
            resultJSON.put("message", (Object)"success");
        }
        catch (Exception ex) {
            log.error("\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u5931\u8d25", (Throwable)ex);
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u5931\u8d25");
        }
        return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
    }

    private int getOrgPlevel(String pid) {
        int plevel = 1;
        if (StrUtil.isBlank((CharSequence)pid) || pid == "0") {
            plevel = 0;
            return plevel;
        }
        if (this.bimOrgLevelCache.hasKey((Object)pid).booleanValue()) {
            String levelStr = (String)this.bimOrgLevelCache.opsForValue().get((Object)pid);
            plevel = Integer.parseInt(levelStr);
        } else {
            BimOrg pOrg = (BimOrg)this.bimOrgService.getById((Serializable)((Object)pid));
            plevel = pOrg == null ? 0 : pOrg.getLevel();
            this.bimOrgLevelCache.opsForValue().set((Object)pid, (Object)(plevel + ""), 90L, TimeUnit.MINUTES);
        }
        return plevel;
    }

    @Override
    public String deleteOrg(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!this.validPermisson(jsonInfo, resultJSON)) {
                return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
            }
            String bimOrgId = (String)jsonInfo.get((Object)"bimOrgId");
            this.organizationService.batchDelete(bimOrgId);
            resultJSON.put("resultCode", (Object)0);
            resultJSON.put("message", (Object)"success");
        }
        catch (Exception ex) {
            log.error("\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u5931\u8d25", (Throwable)ex);
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u8d26\u53f7\u5220\u9664\u5931\u8d25");
        }
        return IamFacade.encrypt((String)resultJSON.toJSONString(), (String)this.bimSecretKey, (String)"SM4");
    }

    private boolean validPermisson(JSONObject jsonInfo, JSONObject resultJSON) {
        resultJSON.put("bimRequestId", jsonInfo.get((Object)"bimRequestId"));
        String usernameBiz = jsonInfo.get((Object)"bimRemoteUser").toString();
        String passwordBiz = jsonInfo.get((Object)"bimRemotePwd").toString();
        if (!usernameBiz.equals(this.bimRemoteUser) || !passwordBiz.equals(this.bimRemotePwd)) {
            resultJSON.put("resultCode", (Object)500);
            resultJSON.put("message", (Object)"\u7528\u6237\u6743\u9650\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        return true;
    }

    private Boolean verify(JSONObject reqmap) {
        StringBuffer sb = new StringBuffer();
        for (String key : reqmap.keySet()) {
            if ("signature".equals(key)) continue;
            sb.append(key).append("=").append(reqmap.get((Object)key)).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        System.out.println(reqmap.get((Object)"signature") + "  now  " + sb.toString());
        return IamFacade.verify((String)reqmap.get((Object)"signature").toString(), (String)sb.toString(), (String)"SM3");
    }
}

