/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.hunan.IDPService;
import com.geoway.design.biz.service.login.ISysLoginService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IDPServiceImpl
implements IDPService {
    @Value(value="${hunan.IDP.url:}")
    private String serverUrl;
    @Value(value="${hunan.IDP.clientId:}")
    private String clientId;
    @Value(value="${hunan.IDP.clientSecret:}")
    private String clientSecret;
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    ISysUserService userService;
    @Autowired
    ISysLoginService sysLoginService;
    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private IOauth2Service ssoOauth2Service;

    @Override
    public String queryAccessToken(String code) throws Exception {
        HashMap<String, String> formMap = new HashMap<String, String>();
        formMap.put("grant_type", "authorization_code");
        formMap.put("code", code);
        formMap.put("client_id", this.clientId);
        formMap.put("client_secret", this.clientSecret);
        String result = HttpRequest.post((String)(this.serverUrl + "idp/oauth2/getToken")).form(formMap).contentType("application/x-www-form-urlencoded").execute().body();
        JSONObject responseJSON = JSONObject.parseObject((String)result);
        if (responseJSON.containsKey((Object)"errcode")) {
            String msg = "\u83b7\u53d6\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5e73\u53f0\u6388\u6743\u7801\u5931\u8d25\uff01" + responseJSON.getString("errcode") + ":" + responseJSON.getString("msg");
            throw new Exception(msg);
        }
        String accessToken = responseJSON.getString("access_token");
        return accessToken;
    }

    @Override
    public SysUser queryUserInfo(String accessToken) throws Exception {
        String result = HttpRequest.get((String)(this.serverUrl + "idp/oauth2/getUserInfo?access_token=" + accessToken)).execute().body();
        JSONObject responseJSON = JSONObject.parseObject((String)result);
        if (responseJSON.containsKey((Object)"errcode")) {
            String msg = "\u83b7\u53d6\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5e73\u53f0\u767b\u5f55\u4ee4\u724c\u5931\u8d25\uff01" + responseJSON.getString("errcode") + ":" + responseJSON.getString("msg");
            throw new Exception(msg);
        }
        String username = responseJSON.getString("userName");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getAccout, (Object)username);
        int iCount = this.userService.count((Wrapper)queryWrapper);
        if (iCount == 0) {
            queryWrapper.clear();
            queryWrapper.and(gw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)gw.eq(SysUser::getName, (Object)username)).or()).eq(SysUser::getAccout, (Object)username);
            });
        }
        queryWrapper.last(" limit 1");
        SysUser user = (SysUser)this.userService.getOne((Wrapper)queryWrapper);
        return user;
    }

    @Override
    public ResponseDataBase loginByAuthCode(HttpServletRequest request, String code) throws Exception {
        String accessToken = this.queryAccessToken(code);
        SysUser user = this.queryUserInfo(accessToken);
        if (user == null) {
            return ResponseDataBase.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7528\u6237\u4fe1\u606f");
        }
        ResponseDataBase response = new ResponseDataBase();
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)user.getId()));
        String password = sysUserSecurity == null ? "" : sysUserSecurity.getPassword();
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), user.getAccout(), password, accessToken);
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        SsoUser ssoUser = rpcAccessToken.getUser();
        response.put((Object)"token", (Object)rpcAccessToken.getAccessToken());
        response.put((Object)"expiresIn", (Object)rpcAccessToken.getExpiresIn());
        response.put((Object)"refreshToken", (Object)rpcAccessToken.getRefreshToken());
        response.put((Object)"userId", (Object)user.getId());
        response.put((Object)"username", (Object)ssoUser.getLoginName());
        response.put((Object)"alisname", (Object)ssoUser.getUserName());
        response.put((Object)"status", (Object)"OK");
        response.put((Object)"validateType", (Object)"sso");
        response.put((Object)"passwordPolicy", (Object)ssoUser.getPasswordPolicy());
        response.put((Object)"regionCode", (Object)ssoUser.getRegionCode());
        response.put((Object)"regionName", (Object)ssoUser.getRegionName());
        return response;
    }

    @Override
    public void logoutByAccessToken(String accessToken) throws Exception {
        String str = HttpRequest.get((String)(this.serverUrl + "idp/oauth2/revokeToken?access_token=" + accessToken)).execute().body();
        JSONObject responseJSON = JSONObject.parseObject((String)str);
        if (responseJSON.containsKey((Object)"errcode")) {
            String msg = "\u9000\u51fa\u767b\u5f55\u5931\u8d25\uff01" + responseJSON.getString("errcode") + ":" + responseJSON.getString("msg");
            throw new Exception(msg);
        }
    }
}

