/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.login.impl;

import cn.org.bjca.client.security.SecurityEngineDeal;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.service.login.ICaLoginService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CaLoginServiceImpl
implements ICaLoginService {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private ISysUserRoleService sysUserRoleService;

    @Override
    public ResponseDataBase checkLogin(String UserCert, String oauthName) {
        ResponseDataBase response = new ResponseDataBase();
        if (oauthName == null) {
            return ResponseDataBase.error((String)"\u7f3a\u5c11\u53c2\u6570oauthName");
        }
        try {
            Result<SsoUser> loginResult = this.validate(UserCert);
            if (loginResult == null) {
                return ResponseDataBase.error((String)"\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (loginResult.getCode() == 9999) {
                return ResponseDataBase.error((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            Result authDto = Result.createSuccess((Object)new AccessTokenContent(codeContent, user, this.projectConfig.getSsoAppId(), null));
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            String newAccessToken = this.accessTokenManager.generate((AccessTokenContent)authDto.getData());
            String refreshToken = this.refreshTokenManager.generate((AccessTokenContent)authDto.getData(), newAccessToken);
            AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
            tokenContent.setRefreshToken(refreshToken);
            this.accessTokenManager.create(newAccessToken, tokenContent);
            RpcAccessToken rpcAccessToken = new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, ((AccessTokenContent)authDto.getData()).getUser());
            SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
            response.put((Object)"token", (Object)rpcAccessToken.getAccessToken());
            response.put((Object)"userId", (Object)user.getId());
            response.put((Object)"username", (Object)user.getLoginName());
            response.put((Object)"alisname", (Object)user.getUserName());
            response.put((Object)"role", (Object)this.sysUserRoleService.listObjs((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysUserRole.class).eq(SysUserRole::getUserid, (Object)user.getId())).select(new SFunction[]{SysUserRole::getRoleid}), a -> (String)a));
            response.put((Object)"status", (Object)"OK");
            response.put((Object)"validateType", (Object)"ca");
            response.put((Object)"passwordPolicy", (Object)user.getPasswordPolicy());
            response.put((Object)"userCatalog", (Object)user.getUserCatalog());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ResponseDataBase.error((String)ex.getMessage());
        }
        return response;
    }

    public Result<SsoUser> validate(String UserCert) {
        try {
            SecurityEngineDeal sed = null;
            sed = SecurityEngineDeal.getInstance((String)"SVSDefault");
            int retValue = sed.validateCert(UserCert);
            if (retValue == 1) {
                String sfz = sed.getCertInfoByOid(UserCert, "2.16.840.1.113732.2");
                if (StringUtils.isNotEmpty((String)sfz)) {
                    sfz = sfz.substring(2);
                    List<SysUser> users = this.sysUserService.queryList("certificateCode_EQ_" + sfz);
                    if (users != null && users.size() > 0) {
                        SysUser user = users.get(0);
                        SsoUser ssoUser = new SsoUser();
                        try {
                            List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
                            String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
                            String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
                            ssoUser.setId(user.getId());
                            ssoUser.setUserid(user.getId());
                            ssoUser.setUserName(user.getAname());
                            ssoUser.setLoginName(user.getAccout());
                            ssoUser.setRegionCode(regionCode);
                            ssoUser.setRegionName(regionName);
                            ssoUser.setUserCatalog(user.getCatalog());
                            return Result.createSuccess((Object)ssoUser);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                }
            } else {
                if (retValue == 0) {
                    return Result.createError((String)"\u9a8c\u8bc1\u65f6\uff0c\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (retValue == -1) {
                    return Result.createError((String)"\u767b\u5f55\u8bc1\u4e66\u7684\u6839\u4e0d\u88ab\u4fe1\u4efb\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (retValue == -2) {
                    return Result.createError((String)"\u767b\u5f55\u8bc1\u4e66\u8d85\u8fc7\u6709\u6548\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (retValue == -3) {
                    return Result.createError((String)"\u767b\u5f55\u8bc1\u4e66\u4e3a\u4f5c\u5e9f\u8bc1\u4e66\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (retValue == -4) {
                    return Result.createError((String)"\u767b\u5f55\u8bc1\u4e66\u88ab\u4e34\u65f6\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

